# 変数を初期化し実行フォルダへ移動
d_sh=$(pwd)
p_id=$(basename ${d_sh})
cd ../../${1}/${2}

# 軽量なopenbox上でGUIアプリケーションを起動
timeout 29 openbox 2>> error.log 1>>error1.log &
timeout 28 python3 myapp.py 2>> error.log 1>>error1.log & sleep 3 2>> error.log 1>>error1.log

# タイトルに基づいてウィンドウを探し，スクリーンショット
w_id=$(xdotool search --onlyvisible --name ${2}) 2>> error.log 1>> error1.log
if [ -z "${w_id}" ]; then
	echo -e "\nプログラムまたはGUIが正しく起動していません" >> error.log
fi
xdotool windowactivate ${w_id} 2>> error.log 1>> error1.log
xdotool windowmove ${w_id} 0 0 2>> error.log 1>> error1.log
scrot -ubz ss_win.png 2>> error.log 1>> error1.log

# GUIの自動操作が指示されている（xdotool.txtがある）場合
if [ -s ${d_sh}/xdotool.txt ]; then
	
	# 行ごとにxdotool向けの命令を実施するが，空行の場合はスクリーンショット
	count=1
	while read line1; do
		if [ "${line1}" ]; then
			xdotool ${line1} 2>> error.log 1>> error1.log
		else
			scrot -ubz /pytmp/${2}/ss_win_${count}.png 2>> error.log 1>> error1.log
			count=$((count+1))
		fi
	done < ${d_sh}/xdotool.txt

	# 画像をトリミングしてアニメーションを生成
	wh_tmp=(`identify -format '%w %h' ss_win.png`)
	mogrify -extent ${wh_tmp[0]}x${wh_tmp[1]} /pytmp/${2}/ss_win_*.png
	cp ss_win.png /pytmp/${2}/ss_win_0.png 2>> error.log 1>> error1.log
	apngasm ss_win.png /pytmp/${2}/ss_win_*.png 1 2 2>> error.log 1>> /dev/null
fi

# ウィンドウを閉じて終了
xdotool sleep 1 windowkill ${w_id} 2>> error.log 1>> error1.log
sleep 1
exit
