# 変数を初期化し実行フォルダへ移動
d_sh=$(pwd)
cd ../../${1}/${2}

# 行ごとにテキストの一致を確認
count=0
while read line1; do
	count=$((count+1))
	echo ${count} >> count.txt
	# 別解を含めて網羅的に確認
	echo "${line1}" | tr '\t' '\n' | while read line2; do
		diff -dBwN --strip-trailing-cr <(sed -n ${count}p a.txt) <(echo "${line2}") > diff_res.log
		if [ ! -s diff_res.log ]; then
			echo ${count} >> res.log
			break
		fi
	done
done < ${d_sh}/answer.txt

rm -f diff_res.log

# 誤り箇所（行）の指摘用ファイルの生成
count=1
while read i; do
	j=`sed -n ${count}p res.log`
	if [[ ${i} -eq ${j} ]]; then
		echo "" >> output.dat
		count=$((count+1))
	else
		echo ">>" >> output.dat
		echo ${i} >> diff_res.log
	fi
done < count.txt

# 判定
if [ -s diff_res.log ]; then
	echo -n "F"
else
	echo -n "G"
fi
