# 変数を初期化し実行フォルダへ移動
d_sh=$(pwd)
p_id=$(basename ${d_sh})
flag_k=0
cd ../../${1}/${2}

# ソースコード群を空の一時フォルダへコピー
rm -fr /pytmp/${2} 2>> error.log
mkdir -p /pytmp/${2}
cp -fr *.py /pytmp/${2} 2>> error.log

# ソースコード群を自動整形した後に結合
mv /pytmp/${2}/myapp.py /pytmp/${2}/_.py
isort /pytmp/${2}/*.py 2>> pc_fmt.log 1>> error.log
autoflake -ri --remove-all-unused-imports --ignore-init-module-imports --remove-unused-variables /pytmp/${2}/*.py 2>> pc_fmt.log 1>> error.log
black --line-length 159 /pytmp/${2}/*.py 2>> pc_fmt.log 1>> error.log
cat /pytmp/${2}/*.py | sed -e '/^[ 	]*#/d' -e 's/[ 	]*$//' 1> output_pc.txt 2>> error.log

# クラスや関数・メソッドの情報を抽出
python3 ${d_sh}/../_default/make_pc2.py < output_pc.txt 1> output_pc2.txt 2>> error.log
if [ -s ${d_sh}/output_pc2.txt ]; then
	flag_k=1
	diff -diN --strip-trailing-cr output_pc2.txt ${d_sh}/output_pc2.txt >> diff_pc2.log
fi

# GUIの自動操作に必要な要素があるか確認
gui_check0=$(python3 -m py_compile myapp.py 2>&1) >> error.log
gui_check1=$(grep -c "^ *import tkinter" output.pc.txt) 2>> error.log
gui_check2=$(grep -c ".title(.*${2}.*)" output_pc.txt) 2>> error.log
gui_check3=$(grep -c '.mainloop()' output_pc.txt) 2>> error.log

# 判定
if [ -s diff_pc2.log ]; then
	echo -e "\nクラスや関数・メソッドを見直してください" >> diff_pc2.log
	echo -n "F"
elif [ -n "${gui_check0}" ]; then
	echo -e "${gui_check0}\nプログラムが起動できないようです\n" >> error.log
	echo -n "F"
elif [ ${gui_check1} -lt 1 ]; then
	echo -e "\nTkinterを利用してください" >> error.log
	echo -n "F"
elif [ ${gui_check2} -lt 1 ]; then
	echo -e "\nウィンドウタイトルに学籍番号を含めてください" >> error.log
	echo -n "F"
elif [ ${gui_check3} -lt 1 ]; then
	echo -e "\n.mainloop()でGUIを起動・待機させてください" >> error.log
	echo -n "F"
else
	echo -n "K"
fi
