# 変数を初期化し実行フォルダへ移動
d_sh=$(pwd)
p_id=$(basename ${d_sh})
flag_k=0
cd ../../${1}/${2}

# ソースコード群を空の一時フォルダへコピー
rm -fr /pytmp/${2} 2>> error.log
mkdir -p /pytmp/${2}
cp -fr *.py /pytmp/${2} 2>> error.log

# ソースコード群を自動整形した後に結合
mv /pytmp/${2}/myapp.py /pytmp/${2}/_.py
isort /pytmp/${2}/*.py 2>> pc_fmt.log 1>> error.log
autoflake -ri --remove-all-unused-imports --ignore-init-module-imports --remove-unused-variables /pytmp/${2}/*.py 2>> pc_fmt.log 1>> error.log
black --line-length 159 /pytmp/${2}/*.py 2>> pc_fmt.log 1>> error.log
cat /pytmp/${2}/*.py | sed -e '/^[ 	]*#/d' -e 's/[ 	]*$//' 1> output_pc.txt 2>> error.log

# クラスや関数・メソッドの情報を抽出
python3 ${d_sh}/../_default/make_pc2.py < output_pc.txt 1> output_pc2.txt 2>> error.log
if [ -s ${d_sh}/output_pc2.txt ]; then
	flag_k=1
	diff -diN --strip-trailing-cr output_pc2.txt ${d_sh}/output_pc2.txt >> diff_pc2.log
fi

# GUIの自動操作に必要な要素があるか確認
gui_check1=`cat output_pc.txt | grep -c "^ *import tkinter"` 2>> error.log
gui_check2=`cat output_pc.txt | grep -c ".title(.*${2}.*)"` 2>> error.log
gui_check3=`cat output_pc.txt | grep -c '.mainloop()'` 2>> error.log

cat output_pc.txt | grep -e ".grid(" | sed -e 's/^[ 	]*//g' | sort 1> output_pc4.txt 2>> error.log
diff -dBwN --strip-trailing-cr output_pc4.txt ${d_sh}/output_pc4.txt >> diff_pc4.log

# 判定
if [ -s diff_pc2.log ]; then
	echo -e "\nクラスや関数・メソッドを見直してください" >> diff_pc2.log
	echo -n "F"
elif [ ${gui_check1} -lt 1 ]; then
	echo -e "\nTkinterを利用してください" >> error.log
	echo -n "F"
elif [ ${gui_check2} -lt 1 ]; then
	echo -e "\nウィンドウタイトルに学籍番号を含めてください" >> error.log
	echo -n "F"
elif [ ${gui_check3} -lt 1 ]; then
	echo -e "\n.mainloop()でGUIを起動・待機させてください" >> error.log
	echo -n "F"
elif [ -s diff_pc4.log ]; then
	echo -n "F"
else
	echo -n "G"
fi
