# 変数を初期化し実行フォルダへ移動
d_sh=$(pwd)
p_id=$(basename ${d_sh})
flag_k=0
cd ../../${1}/${2}

# ソースコード群を空の一時フォルダへコピー
rm -fr /pytmp/${2} 2>> error.log
mkdir -p /pytmp/${2}
cp -fr *.py /pytmp/${2} 2>> error.log

# ソースコード群を自動整形した後に結合
mv /pytmp/${2}/myapp.py /pytmp/${2}/_.py
isort /pytmp/${2}/*.py 2>> pc_fmt.log 1>> error.log
autoflake -ri --remove-all-unused-imports --ignore-init-module-imports --remove-unused-variables /pytmp/${2}/*.py 2>> pc_fmt.log 1>> error.log
black --line-length 159 /pytmp/${2}/*.py 2>> pc_fmt.log 1>> error.log
cat /pytmp/${2}/*.py | sed -e '/^[ 	]*#/d' -e 's/[ 	]*$//' 1> output_pc.txt 2>> error.log

# クラスや関数・メソッドの情報を抽出
python3 ${d_sh}/../_default/make_pc2.py < output_pc.txt 1> output_pc2.txt 2>> error.log
if [ -s ${d_sh}/output_pc2.txt ]; then
	flag_k=1
	diff -diN --strip-trailing-cr output_pc2.txt ${d_sh}/output_pc2.txt >> diff_pc2.log
fi

# hanhan.txt を差し替えながら自動実行，hanhan2.txt を比較
for f_i in ${d_sh}/input*.dat; do
	cp -f ${f_i} hanhan.txt 2>> error.log
	f_o=$(basename ${f_i/input/output})
	timeout 5 python3 myapp.py | sed -r 's/\x1b\[[0-9;]*[a-zA-Z]//g' | head -n 5000 | head -c 256K 1>> output_dummy.txt 2>> error.log
	mv hanhan2.txt ${f_o}
	if [ -s ${d_sh}/${f_o} ]; then
		flag_k=1
		diff -dBwN --strip-trailing-cr ${f_o} ${d_sh}/${f_o} >> diff_res.log
	fi
done

# with文が1回だけ使われているか確認
diff -dBw --strip-trailing-cr <(cat output_pc.txt | grep -c -e "^ *with open(.*, open(") <(echo -e "1") >> diff_pc4.log

# 判定
if [ ${flag_k} -eq 0 ]; then
	echo -n "K"
elif [ -s diff_pc2.log ]; then
	echo -e "\nクラスや関数・メソッドを見直してください" >> diff_pc2.log
	echo -n "F"
elif [ -s diff_res.log ]; then
	echo -e "\n実行結果が異なります" >> diff_res.log
	echo -n "F"
elif [ -s diff_pc4.log ]; then
	echo -e "\nwith文が使われていないか，複数回使われています" >> diff_pc4.log
	echo -n "G"
else
	echo -n "S"
fi
