# -*- coding: utf-8 -*-
"""
選択ソート（昇順）
"""


import random


# 整数乱数（0-19）のlistを作成
def make_ints_r(n):
    x = []
    for i in range(n):
        x.append(random.randrange(20))
    return x


# データ列（整数）を文字列化
# 分かりやすさのため，一部を色付け（ターミナル上）
def ints_to_str(x, m=[]):
    x_strs = []  # 文字列化されたデータ列を保持するlist
    for i in range(len(x)):
        # インデックスがmに含まれていれば背景を赤色に
        if i in m:
            x_strs.append(f"\033[4;101m{x[i]:2d}\033[0m")
        else:
            x_strs.append(f"{x[i]:2d}")
    # 結合して戻す
    return ",".join(x_strs)


# 目盛を表示
# 分かりやすさのため，全て色付け（ターミナル上）
def print_index(n):
    # 目盛をlistで準備
    tics = [f"{i:2d}" for i in range(n)]
    # 背景を青色にしつつ結合し表示
    print("index\033[4;104m " + ",".join(tics) + "\033[0m")


# バブルソート
def bubble_sort(x):
    cnt = 0         # 交換回数
    n = len(x) - 2  # 範囲の幅

    for li in range(n+1):             # 範囲は徐々に右に絞る
        for j in range(n, li-1, -1):  # 比較位置は徐々に左に
            if x[j] > x[j+1]:          # 左＞右なら
                x[j], x[j+1] = x[j+1], x[j]  # 交換
                cnt += 1
                # 交換位置を赤色で表示
                print(f"[{cnt:03d}]", ints_to_str(x, [j, j+1]))


# 選択ソート
def selection_sort(x):
    cnt = 0         # 交換回数
    n = len(x) - 1  # 範囲の幅

    for li in range(n):  # 範囲は徐々に右に絞る
        k = li  # 最小値の位置を範囲の左端で初期化
        # 最小値を探索
        for j in range(li+1, n+1):  # 比較位置は徐々に左に
            if x[j] < x[k]:   # 現在の最小値より小さいなら
                k = j         # 最小値の位置を更新
        
        x[li], x[k] = x[k], x[li]  # 範囲の左端と最小値を交換
        cnt += 1
        print(f"[{cnt:03d}]", ints_to_str(x, [li, k]))


def main():
    # 乱数を準備
    try:
        # 整数が入力された場合は，それを種とする
        rnd_seed = int(input("乱数の種（入力が整数以外なら自動設定）："))
        random.seed(rnd_seed)
    except TypeError:
        # 整数でなかった場合は，デフォルト（自動設定）
        pass
    print()  # 採点の都合上の空行 

    # 各データの準備
    n = 30
    x = make_ints_r(n)  # 整数のデータ列

    # ヘッダー部を表示
    print_index(n)
    print("val_1", ints_to_str(x))

    # 選択ソートを実施
    selection_sort(x)

    # 結果を表示
    print("val_1", ints_to_str(x))
    print_index(n)


if __name__ == "__main__":
    main()
