d_sh=$(pwd)
p_id=$(basename ${d_sh})
flag_k=0
cd ../../${1}/${2}

rm -fr /pytmp/${2} 2>> error.log
mkdir -p /pytmp/${2}
cp -fr *.py /pytmp/${2} 2>> error.log
mv /pytmp/${2}/myapp.py /pytmp/${2}/_.py
isort /pytmp/${2}/*.py 2>> pc_fmt.log 1>> error.log
autoflake -ri --remove-all-unused-imports --ignore-init-module-imports --remove-unused-variables /pytmp/${2}/*.py 2>> pc_fmt.log 1>> error.log
black --line-length 159 /pytmp/${2}/*.py 2>> pc_fmt.log 1>> error.log
cat /pytmp/${2}/*.py | sed -e '/^[ 	]*#/d' -e 's/[ 	]*$//' 1> output_pc.txt 2>> error.log

cat output_pc.txt | python3 ${d_sh}/../_default/make_pc2.py 1> output_pc2.txt 2>> error.log
if [ -s ${d_sh}/output_pc2.txt ]; then
	flag_k=1
	diff -diN --strip-trailing-cr output_pc2.txt ${d_sh}/output_pc2.txt >> diff_pc2.log
fi

timeout 5 python3 myapp.py | sed -r 's/\x1b\[[0-9;]*[a-zA-Z]//g' | head -n 5000 | head -c 256K > output.dat
flag_k=1
diff -dBwN --strip-trailing-cr output.dat <(echo ${2}; date "+%Y") >> diff_res.log

if [ ${flag_k} -eq 0 ]; then
	echo -n "K"
elif [ -s diff_pc2.log ]; then
	echo -n "F"
elif [ -s diff_res.log ]; then
	echo -n "F"
else
	echo -n "G"
fi
