<?php
	function make_mysqli_acc_ctrl(){
		// DBへ接続
		try{
			$dbh = new PDO("mysql:host=localhost;dbname=acc_ctrl;charset=utf8mb4", "senmon", "mouri3");
			$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		}
		catch(PDOException $e){
			exit("DB（アクセス制御）への接続に失敗しました．<br>");
		}
		
		return $dbh;
	}
	
	
	function decrypt_passwd($cpt_passwd, $PFX_KEYN){
		$passwd = (array)$cpt_passwd;
		$rsa_pem = file_get_contents(__DIR__."/keys/{$PFX_KEYN}private.pem");
		$rsa_key = openssl_pkey_get_private($rsa_pem)
			or exit("複号鍵を読み込めませんでした．<br>");
		for($i = 0; $i < count($passwd); $i++){
			$passwd[$i] = base64_decode($passwd[$i]);
			openssl_private_decrypt($passwd[$i], $passwd[$i], $rsa_key)
				or exit("パスワードの複号に失敗しました．<br>");
			$passwd[$i] = substr($passwd[$i], 8);
		}
		openssl_free_key($rsa_key);
		
		if(count($passwd) == 1){
			$passwd = $passwd[0];
		}
		return $passwd;
	}
	
	
	function add_graylist($u_id = NULL, $ip_str = NULL, $rq_uri = NULL, $time_now = NULL){
		if(empty($u_id)){
			$u_id = $_POST['u_id'];
		}
		if(empty($ip_str)){
			$ip_str = $_SERVER['REMOTE_ADDR'];
		}
		if(empty($rq_uri)){
			$rq_uri = $_SERVER['REQUEST_URI'];
		}
		if(empty($time_now)){
			$time_now = time();
		}
		$time_str = date("Y-m-d H:i:s", $time_now);
		$dbh      = make_mysqli_acc_ctrl();
		
		$sqlstr = "INSERT INTO graylist(time,u_id,ip_str,rq_uri) VALUES('{$time_str}','{$u_id}','{$ip_str}','{$rq_uri}');";
		if($dbh->query($sqlstr) === FALSE){
			return FALSE;
		}
		
		return TRUE;
	}
	
	
	function is_denied($u_id, $ip_str, $d_path = "/", $time_now = NULL){
		if(empty($u_id)){
			$u_id = $_POST['u_id'];
		}
		if(empty($ip_str)){
			$ip_str = $_SERVER['REMOTE_ADDR'];
		}
		if(empty($time_now)){
			$time_now = time();
		}
		$time_str = date("Y-m-d H:i", $time_now);
		$ip_rmt   = ip2long($ip_str);
		$dbh      = make_mysqli_acc_ctrl();
		
		$sqlstr = "SELECT * FROM whitelist;";
		try{
			$result = $dbh->query($sqlstr);
		}
		catch(PDOException $e){
			return 3;
		}
		
		while($data = $result->fetch(PDO::FETCH_ASSOC)){
			if(empty($data['t_lim'])){
				$data['t_lim'] = $time_str;
			}
			if(empty($data['u_id'])){
				$data['u_id'] = $u_id;
			}
			if(empty($data['ip_int'])){
				$data['ip_int'] = 0;
			}
			if(empty($data['ip_msk'])){
				$data['ip_msk'] = 0;
			}
			if(empty($data['d_path'])){
				$data['d_path'] = $d_path;
			}
			if(($data['t_lim'] <= $time_str) && ($data['u_id'] == $u_id) && ($data['d_path'] == $d_path)){
				$ip_int2 = $data['ip_int'] >> (32 - $data['ip_msk']);
				$ip_rmt2 = $ip_rmt >> (32 - $data['ip_msk']);
				if($ip_int2 == $ip_rmt2){
					return 0;
				}
			}
		}
		
		$sqlstr = "SELECT * FROM blacklist;";
		try{
			$result = $dbh->query($sqlstr);
		}
		catch(PDOException $e){
			return 4;
		}
		
		while($data = $result->fetch(PDO::FETCH_ASSOC)){
			if(empty($data['u_id'])){
				$data['u_id'] = $u_id;
			}
			if(empty($data['ip_int'])){
				$data['ip_int'] = 0;
			}
			if(empty($data['ip_msk'])){
				$data['ip_msk'] = 0;
			}
			if(empty($data['d_path'])){
				$data['d_path'] = $d_path;
			}
			if(($data['u_id'] == $u_id) && ($data['d_path'] == $d_path)){
				$ip_int2 = $data['ip_int'] >> (32 - $data['ip_msk']);
				$ip_rmt2 = $ip_rmt >> (32 - $data['ip_msk']);
				if($ip_int2 == $ip_rmt2){
					return 1;
				}
			}
		}
		
		$time_b1d = date("Y-m-d H:i:s", $time_now - 86400);
		$sqlstr = "SELECT * FROM graylist WHERE ((time>='{$time_b1d}') AND (is_dis IS false) AND (u_id='{$u_id}' OR ip_str='{$ip_str}')) ORDER BY time DESC;";
		try{
			$result = $dbh->query($sqlstr);
		}
		catch(PDOException $e){
			return 5;
		}
		
		$num_rows = $result->rowCount();
		if($num_rows >= 5){
			return 2;
		}
		if($num_rows >= 4){
			$data = $result->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_ABS, 3);
			if($data['time'] >= date("Y-m-d H:i:s", $time_now - 7200)){
				return 2;
			}
		}
		if($num_rows >= 3){
			$data = $result->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_ABS, 2);
			if($data['time'] >= date("Y-m-d H:i:s", $time_now - 600)){
				return 2;
			}
		}
		
		return 0;
	}
	
	
	function eh_for_is_denied($result){
		switch($result){
			case 0:
				break;
			case 1:
				exit("ブラックリストに載っているためロック中です．<br>管理者に問い合わせてください．<br>");
				break;
			case 2:
				exit("ログイン認証に失敗しすぎたためロック中です．<br>しばらく待つか，管理者に問い合わせてください．<br>");
				break;
			case 3:
//				exit("ホワイトリストの読み出しに失敗しました．<br>");
//				break;
			case 4:
//				exit("ブラックリストの読み出しに失敗しました．<br>");
//				break;
			case 5:
//				exit("グレーリストの読み出しに失敗しました．<br>");
				exit("DB（アクセス制御）への要求に失敗しました．<br>");
				break;
			default:
				exit("不明なエラーです．<br>");
		}
	}
	
	
	function auth_by_ldap($u_id, $passwd){
		$ldap_server   = "";
		$ldap_sch_base = "";
		$ldap_bind_dn  = "";
		$ldap_bind_pw  = "";
		
		if(!($ldap_conn = ldap_connect($ldap_server))){
			return 3;
		}
		if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)){
			return 4;
		}
		if(!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)){
			return 5;
		}
		if(!($ldap_bind_st = ldap_bind($ldap_conn, $ldap_bind_dn, $ldap_bind_pw))){
			return 6;
		}
		
		$sr = ldap_search($ldap_conn, $ldap_sch_base, "uid=".$u_id);
		$info = ldap_get_entries($ldap_conn, $sr);
		if($info['count'] == 0){
			ldap_close($ldap_conn);
			return 1;
		}
		if(!ldap_bind($ldap_conn, $info[0]['dn'], $passwd)){
			ldap_close($ldap_conn);
			return 2;
		}
		
		ldap_close($ldap_conn);
		return 0;
	}
	
	
	function eh_for_auth_by_ldap($result, $u_id = NULL, $ip_str = NULL, $rq_uri = NULL, $time_now = NULL){
		if(empty($u_id)){
			$u_id = $_POST['u_id'];
		}
		if(empty($ip_str)){
			$ip_str = $_SERVER['REMOTE_ADDR'];
		}
		if(empty($rq_uri)){
			$rq_uri = $_SERVER['REQUEST_URI'];
		}
		if(empty($time_now)){
			$time_now = time();
		}
		
		switch($result){
			case 0:
				break;
			case 1:
				echo "ユーザIDが登録されていません．<br>大学の PC にログインするときに使うID（学籍番号）を使ってください．<br> ";
				add_graylist($u_id, $ip_str, $rq_uri, $time_now)
					or exit("DB（アクセス制御）への登録に失敗しました．<br>");
				exit();
				break;
			case 2:
				echo "パスワード認証が通りません．<br>大学の PC にログインするときに使うパスワードを使ってください．<br>";
				add_graylist($u_id, $ip_str, $rq_uri, $time_now)
					or exit("DB（アクセス制御）への登録に失敗しました．<br>");
				exit();
				break;
			case 3:
//				exit("LDAPサーバへの接続に失敗しました．<br>");
//				break;
			case 4:
//				exit("LDAPのPROTOCOL_VERSIONの設定に失敗しました．<br>");
//				break;
			case 5:
//				exit("LDAPのREFERRALSの設定に失敗しました．<br>");
//				break;
			case 6:
//				exit("LDAPのバインドに失敗しました．<br>");
				exit("LDAP関連のエラーです．<br>");
				break;
			default:
				exit("不明なエラーです．<br>");
		}
	}
	
	
	function get_os_br($str_ua){
		$str_os = "Unknown OS";
		$str_bw = "Unknown BW";

		if    ($i = strpos($str_ua, "Windows NT")){
			$str_os = "Win_NT/". substr($str_ua, $i+11, strpos($str_ua, " ", $i+11)-$i-12);
		}
		elseif($i = strpos($str_ua, "iPhone OS")){
			$str_os = "iPhone/". substr($str_ua, $i+10, strpos($str_ua, " ", $i+10)-$i-11);
		}
		elseif($i = strpos($str_ua, "iPad OS")){
			$str_os = "iPad/".   substr($str_ua, $i+ 8, strpos($str_ua, " ", $i+ 8)-$i-9);
		}
		elseif($i = strpos($str_ua, "Mac OS X")){
			$str_os = "Mac_OSX/".substr($str_ua, $i+ 9, strpos($str_ua, " ", $i+ 9)-$i-10);
		}
		elseif($i = strpos($str_ua, "Android")){
			$str_os = "Android/".substr($str_ua, $i+ 8, strpos($str_ua, " ", $i+ 8)-$i-9);
		}
		elseif($i = strpos($str_ua, "Linux ")){
			$str_os = "Linux/".  substr($str_ua, $i+ 6, strpos($str_ua, " ", $i+ 6)-$i-7);
		}

		if    (strpos($str_ua, "Edg"))     $str_bw = "Edge";
		elseif(strpos($str_ua, "Chrome"))  $str_bw = "Chrome";
		elseif(strpos($str_ua, "Safari"))  $str_bw = "Safari";
		elseif(strpos($str_ua, "Firefox")) $str_bw = "Firefox";
		elseif(strpos($str_ua, "MSIE")  || strpos($str_ua, "Trident")) $str_bw = "MSIE";
		elseif(strpos($str_ua, "Opera") || strpos($str_ua, "OPR/"))    $str_bw = "Opera";

		return $str_os.", ".$str_bw;
	}
	
?>
