<!doctype html>
<?php
	// pgnpgr用
	require_once("./config.php");
	
	// DBへ接続
	try{
		$dbh = new PDO("mysql:host=localhost;dbname={$DB_NAME};charset=utf8mb4", $DB_USER, $DB_PW);
		$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}
	catch(PDOException $e){
		exit("DBへの接続に失敗しました．<br>");
	}
	
	ob_start();
	
	// ユーザ情報の新規登録・更新
	$cb = $_POST['cb'];
	foreach($cb as $id){
		// 各情報の取得
		echo "ユーザ {$id} の更新処理<br>";
		$u_id_2 = str_replace(" ", "", strtolower($_POST['u_id'][''.$id]));
		$u_name = $dbh->quote(mb_convert_kana($_POST['u_name'][''.$id], "s"));
		$u_yomi = $dbh->quote(mb_convert_kana($_POST['u_yomi'][''.$id], "sKVCa"));
		$cls_id = isset($_POST['cls_id'][''.$id]) ? $_POST['cls_id'][''.$id] : "0";
		$grd_id = isset($_POST['grd_id'][''.$id]) ? $_POST['grd_id'][''.$id] : "0";
		$e_mail = $dbh->quote($_POST['e_mail'][''.$id]);
		if(empty($cls_id)) $cls_id = "0";
		if(empty($grd_id)) $grd_id = "0";
		
		// ユーザ情報の新規登録
		if($id < 0){
			$sqlstr = "INSERT INTO users VALUES ('{$u_id_2}','',{$u_name},{$u_yomi},{$cls_id},{$grd_id},{$e_mail});";
			if($dbh->exec($sqlstr) !== FALSE){
				echo "ユーザ情報を新規登録しました．<br><br>";
				$sqlstr = "INSERT INTO evals (u_id) VALUES ('{$u_id_2}');";
				if($dbh->exec($sqlstr) !== FALSE){
					echo "evalsへの追加に成功しました．<br><br>";
					continue;
				}
			}
			echo "<span style=\"color:red;\"><b>ユーザ情報の新規登録に失敗しました．<br></b></span>";
		}
		// ユーザ情報の更新
		else{
			$err_msg = "";
			$sqlstr = "UPDATE users SET u_id='{$u_id_2}',u_name={$u_name},u_yomi={$u_yomi},cls_id={$cls_id},grd_id={$grd_id},e_mail={$e_mail} WHERE u_id='{$id}';";
			if($dbh->exec($sqlstr) !== FALSE){
				// u_id を更新する場合，他のテーブル上も更新することが必要
				if(strcmp($id, $u_id_2) !== 0){
					$sqlstr = "SELECT table_name FROM information_schema.columns WHERE column_name='u_id' and table_schema='{$DB_NAME}'";
					$result_UITBL = $dbh->query($sqlstr);
					while($data = $result_UITBL->fetch(PDO::FETCH_ASSOC)){
						$sqlstr = "UPDATE {$data['table_name']} SET u_id='{$u_id_2}' WHERE u_id='{$id}';";
						if($dbh->exec($sqlstr) === FALSE){
							$err_msg .= ",{$data['table_name']}.u_id";
						}
					}
					$sqlstr = "SELECT table_name FROM information_schema.columns WHERE column_name='list_u' and table_schema='{$DB_NAME}'";
					$result_ULTBL = $dbh->query($sqlstr);
					while($data = $result_ULTBL->fetch(PDO::FETCH_ASSOC)){
						$sqlstr = "UPDATE {$data['table_name']} SET list_u=REPLACE(list_u,',{$id},',',{$u_id_2},') WHERE FIND_IN_SET('{$id}', list_u);";
						if($dbh->exec($sqlstr) === FALSE){
							$err_msg .= ",{$data['table_name']}.list_u";
						}
					}
				}
			}
			else{
				$err_msg .= ",users.u_id";
			}
			if(empty($err_msg)){
				echo "ユーザ情報を更新しました．<br><br>";
				continue;
			}
			echo "<span style=\"color:red;\"><b>ユーザ情報の更新に失敗しました(".substr($err_msg, 1).")．<br></b></span>";
		}
	}
	
	$html_str = ob_get_clean();
?>
<html>
<head>
	<meta charset="UTF-8" http-equiv="Refresh" content="5; URL=./edit_us.php">
	<meta name="viewport" content="width=device-width,initial-scale=1.0">
	<title><?= $SV_TITLE; ?></title>
	<link rel="stylesheet" type="text/css" href="basea.css">
</head>
<body>
<?php
	echo $html_str;
?>
	<br>
	５秒後にユーザ情報の確認・更新ページへ移動します．<br>
</body>
</html>
