<!doctype html>
<?php
	require_once("./config.php");
	
	// DBへ接続
	try{
		$dbh = new PDO("mysql:host=localhost;dbname={$DB_NAME};charset=utf8mb4", $DB_USER, $DB_PW);
		$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}
	catch(PDOException $e){
		exit("DBへの接続に失敗しました．<br>");
	}
	
	$d_path_t = $PATH_SWD."_test/";
	$d_list = glob($d_path_t."[0-9][0-9]*", GLOB_ONLYDIR);
	foreach($d_list as $d_path_p){
		$p_id = basename($d_path_p);
		$ini = parse_ini_file($d_path_p."/setting.txt");
		if(isset($ini['type']) || !is_int($ini['type'])){
			$type = $ini['type'];
		}
		else{
			$type = 1;
		}
		if(empty($title = $dbh->quote($ini['title']))){
			$title = "'無題'";
		}
		if(empty($dist = $dbh->quote($ini['dist']))){
			$dist = "''";
		}
		$sqlstr = "REPLACE INTO p_bank VALUES ({$p_id}, {$type}, {$title}, {$dist});";
		if($dbh->exec($sqlstr) === FALSE){
			echo "<span style=\"color:red;\"><b>課題番号 {$p_id} の登録に失敗しました．<br></b></span>";
			continue;
		}
		else{
			echo "課題番号 {$p_id} の登録に成功しました．<br>";
		}
	}
?>
<html>
<head>
	<meta charset="UTF-8" http-equiv="Refresh" content="5; URL=./admin.php">
	<meta name="viewport" content="width=device-width,initial-scale=1.0">
	<title><?= $SV_TITLE; ?></title>
	<link rel="stylesheet" type="text/css" href="basea.css">
</head>
<body>
	<br>
	５秒後に授業情報一覧ページへ移動します．<br>
</body>
</html>
