<!doctype html>
<?php
	require_once("./config.php");
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta name="viewport" content="width=device-width,initial-scale=1.0">
	<title><?= $SV_TITLE; ?> 採点結果ページ</title>
	<link rel="stylesheet" type="text/css" href="base.css">
</head>
<body>
<?php
	sleep(1);
	$p_id   = $_GET['p_id'];
	$l_id   = $_GET['l_id'];
	$sub_id = $_GET['sub_id'];
	$les_id = sprintf("%02d%d", $l_id, $sub_id);
	$f_ul   = $_FILES['file'];
	
	// DBへ接続
	try{
		$dbh = new PDO("mysql:host=localhost;dbname={$DB_NAME};charset=utf8mb4", $DB_USER, $DB_PW);
		$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}
	catch(PDOException $e){
		exit("DBへの接続に失敗しました．<br>");
	}
	
	$sqlstr = "INSERT INTO ulogs VALUES (NULL,NOW(3),'{$u_id}','{$_SERVER['REMOTE_ADDR']}','{$_SESSION['os_br']}','File Upload: {$f_name} of {$les_id}.');";
	$dbh->exec($sqlstr);

	if($f_ul['error'] > 0){
		echo "ファイルエラーです．PHPの_FILESのエラーコード： {$f_ul['error']} を参照して下さい．<br>";
		goto label1;
	}
	if($f_ul['size'] > 105000000){
		echo "<span style\"color:red;\"><b>100MB以下のファイルのみ提出できます．<br></b></span>";
		goto label1;
	}
	
	$f_ext = mb_strtolower(pathinfo($f_ul['name'], PATHINFO_EXTENSION));
	switch($f_ext){
		case "py":
		case "pyw":
		case "txt":
			$f_name = "myapp.py";
			$f_ext  = "py";
			break;
		case "pyz":
		case "zip":
			$f_name = "a.zip";
			$f_ext  = "zip";
			break;
		default:
			echo "不正な提出です．<br>";
			goto label1;
	}
	
	$f_path = "{$PATH_SWD}{$les_id}/{$u_id}/";
	mkdir($f_path, 0775, TRUE);
	chmod($f_path, 0775);
	shell_exec("rm -fr {$f_path}*");
	if(move_uploaded_file($f_ul['tmp_name'], $f_path.$f_name)){
		echo "ファイルを保存しました．<br>";
		if($f_ext == "zip"){
			$uz_cmd = "unzip -qq -jo {$f_path}a.zip -d {$f_path}.";
			$uz_res = shell_exec($uz_cmd);
			if(file_exists("{$f_path}myapp.pyw")){
				rename("{$f_path}myapp.pyw", "{$f_path}myapp.py");
			}
			if(!(file_exists("{$f_path}myapp.py"))){
				echo "myapp.py が存在しません．<br>";
				goto label1;
			}
		}
	}
	else{
		echo "<span style=\"color:red;\"><b>サーバ側のエラーにより，ファイルの保存に失敗しました．<br></b></span>";
		echo "<span style=\"color:red;\"><b>エラーが続くようでしたら，<a href=\"mailto:{$ADM_MAIL}?subject={$PFX_MSBJ}\" target=\"_blank\">管理者（{$ADM_NAME}）</a>まで連絡して下さい．<br></b></span>";
		$sqlstr = "INSERT INTO ulogs VALUES (NULL,NOW(3),'{$u_id}','{$_SERVER['REMOTE_ADDR']}','{$_SESSION['os_br']}','Error! File {$les_id}.');";
		$dbh->exec($sqlstr);
		goto label1;
	}
	
	$time_str = date("Y-m-d H:i", $time_now);
	$d_path_t = sprintf("%s_test/%04d", $PATH_SWD, $p_id);
	$test_cmd = "cd {$d_path_t}; export LANG=ja_JP.UTF-8; timeout 16 ";
	if(file_exists("{$d_path_t}/test_cmd.sh")){
		$test_cmd .= "bash test_cmd.sh {$les_id} {$u_id}";
	}
	else{
		$test_cmd .= "bash ../_default/test_cmd{$_POST['type']}.sh {$les_id} {$u_id}";
	}
	$test_res = shell_exec($test_cmd);
	if(($_POST['type'] == 3) && ($test_res != "F")){
		$test_cmd = "cd {$d_path_t}; export LANG=ja_JP.UTF-8; xvfb-run -a timeout 35 ";
		if(file_exists("{$d_path_t}/test_xdo.sh")){
			$test_cmd .= "bash test_xdo.sh {$les_id} {$u_id} > /dev/null 2>&1 &";
		}
		else{
			$test_cmd .= "bash ../_default/test_xdo.sh {$les_id} {$u_id} > /dev/null 2>&1 &";
		}
		shell_exec($test_cmd);
		sleep(4);
	}
	
	switch($test_res){
	case null:
		echo "処理がタイムアウトしたか，何らかのエラーが発生しました．<br>実行中に意図しない無限ループが生じないか，手元で何パターンか確認してください．<br>GUIの課題の場合は，ウィンドウタイトルに自身の学籍番号が含まれているか確認してください．<br>不合格としておきますが，タイムアタック系の課題の場合は「確認中」と同等です．<br>";
		$sqlstr = "UPDATE evals SET s{$les_id}=1 WHERE u_id='{$u_id}' AND s{$les_id}<5;";
		break;
	case "K":
		if($time_str <= $_POST['t_late']){
			echo "確認中です．判定まで数日かかる場合もあります．<br>";
			$sqlstr = "UPDATE evals SET s{$les_id}= CASE WHEN s{$les_id}<5 THEN 4 WHEN s{$les_id}=5 THEN 6 ELSE s{$les_id} END WHERE u_id='{$u_id}';";
		}
		else{
			echo "確認中（遅刻提出）です．判定まで数日かかる場合もあります．<br>";
			$sqlstr = "UPDATE evals SET s{$les_id}= CASE WHEN s{$les_id}<5 THEN 2 WHEN s{$les_id}=5 THEN 6 ELSE s{$les_id} END WHERE u_id='{$u_id}';";
		}
		break;
	case "S":
		if($time_str <= $_POST['t_late']){
			echo "合格（加点対象）です．<br>";
			$sqlstr = "UPDATE evals SET s{$les_id}=7 WHERE u_id='{$u_id}' AND s{$les_id}<7;";
?>
	<div id="firework" style="position:fixed; top:0; left:0; z-index:-1;"></div>
	<script src="/js/p5.min.js"></script>
	<script src="/js/firework.js"></script>
<?php
		}
		else{
			echo "合格（遅刻提出）です．<br>";
			$sqlstr = "UPDATE evals SET s{$les_id}=3 WHERE u_id='{$u_id}' AND s{$les_id}<3;";
		}
		break;
	case "G":
		if($time_str <= $_POST['t_late']){
			echo "合格です．<br>";
			$sqlstr = "UPDATE evals SET s{$les_id}=5 WHERE u_id='{$u_id}' AND s{$les_id}<5;";
		}
		else{
			echo "合格（遅刻提出）です．<br>";
			$sqlstr = "UPDATE evals SET s{$les_id}=3 WHERE u_id='{$u_id}' AND s{$les_id}<3;";
		}
		break;
	default:
		echo "不合格です．<br>";
		$sqlstr = "UPDATE evals SET s{$les_id}=1 WHERE u_id='{$u_id}' AND s{$les_id}<5;";
	}
	if($dbh->exec($sqlstr) === FALSE){
		exit("評価の更新に失敗しました．<br>");
	}
	
	$sqlstr = "INSERT INTO ulogs VALUES (NULL,NOW(3),'{$u_id}','{$_SERVER['REMOTE_ADDR']}','{$_SESSION['os_br']}','Test Result: {$les_id} = {$test_res}.');";
	$dbh->exec($sqlstr);
	
label1:
?>
	<table border="1" class="t">
		<thead>
<tr><th>あなたのプログラムの実行結果</th><th>正解プログラムの実行結果</th></tr>
		</thead>
		<tbody>
<?php
	// GUI起動画面用
	$f_path = sprintf("%s%02d%d/%s/ss_win.png", $PATH_SWD, $l_id, $sub_id, $u_id);
	if(file_exists($f_path)){
		echo "<tr><td class=\"t\"><img src=\"./disp_png.php?l_id={$l_id}&sub_id={$sub_id}&f_name=ss_win\" loading=\"lazy\"><br>\n※起動時の静止画の場合があります．</td><td class=\"t\">";
		$f_path = sprintf("%s_test/%s/ss_win.png", $PATH_SWD, $p_id);
		if(file_exists($f_path)){
			echo "<img src=\"./disp_png.php?p_id={$p_id}&f_name=ss_win.png\" loading=\"lazy\">";
		}
		else{
			echo "正解例のスクリーンショットはありません．";
		}
		echo "</td></tr>\n";
	}

	$fn = 0;
	foreach(glob(sprintf("%s_test/%04d/output*.dat", $PATH_SWD, $p_id)) as $fc){
?>
<tr>
<td class="t"><pre>
<?php
		echo "<p id=\"txt_u{$fn}\">";
		$fu = "{$PATH_SWD}{$les_id}/{$u_id}/".basename($fc);
		echo htmlspecialchars(file_get_contents($fu, length: 100000));
		echo "</p>";
?>
</pre></td>
<td class="t"><pre>
<?php
		echo "<p id=\"txt_c{$fn}\">";
		echo htmlspecialchars(file_get_contents($fc));
		echo "</p>";
?>
</pre></td>
</tr>
<?php
		$fn++;
	}
?>
		</tbody>
	</table>
	<b>注：入力は自動のため非表示</b><br>
	<br>
	<table border="1">
<tr><th colspan="2">自動採点用ログ</th></tr>
<?php
	foreach(glob("{$PATH_SWD}{$les_id}/{$u_id}/*.log") as $f1){
		if(filesize($f1) <= 0) continue;
?>
<tr>
<td class="t"><pre>
<?= htmlspecialchars(basename($f1)); ?>
</pre></td>
<td class="t"><pre>
<?= htmlspecialchars(file_get_contents($f1)); ?>
</pre></td>
</tr>
<?php
	}
?>
	</table>
	<br>
	<br><a href="#" onClick="window.history.back(); return false;">課題に戻る</a><br>
	<br>
	<br><a href="./show_eu.php">課題一覧に戻る</a><br>
	<script src="/js/jquery-3.min.js"></script>
	<script src="/js/diff_match_patch.js"></script>
	<script>
<!--
	window.addEventListener('load', function () {
		for(var i = 0; i < <?= $fn; ?>; i++){
			var txt_u = $('#txt_u' + i).text().replace(/\r?\n/g, '\n');
			var txt_c = $('#txt_c' + i).text().replace(/\r?\n/g, '\n');
			var dmp   = new diff_match_patch();
			var dif_u = dmp.diff_main(txt_c, txt_u);
			var dif_c = dmp.diff_main(txt_u, txt_c);
			$('#txt_u' + i).html( dmp.diff_prettyHtml(dif_u).replace("&para;", "") );
			$('#txt_c' + i).html( dmp.diff_prettyHtml(dif_c).replace("&para;", "") );
		}
	});
// -->
	</script>
</body>
</html>
