<!doctype html>
<?php
	require_once("./config.php");
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta name="viewport" content="width=device-width,initial-scale=1.0">
	<title><?= $SV_TITLE; ?> 内部ディレクトリの一覧ページ</title>
	<link rel="stylesheet" type="text/css" href="basea.css">
	<link rel="stylesheet" type="text/css" href="form.css">
</head>
<body>
	<h1><?= $SV_TITLE; ?></h1>
	<h2>内部ディレクトリの一覧ページ</h2>
	<br>
<?php
	$d_path = dirname($PATH_SWD);
	foreach(glob("{$d_path}/[0-9]*", GLOB_ONLYDIR) as $fc){
		$year = basename($fc);
		echo "<details><summary>{$year}　<a href=\"./archive_swd.php?year={$year}\">圧縮</a><br></summary>\n";
		for($l_id = 1; $l_id < 16; $l_id++){
			$l_0id = sprintf("%02d", $l_id);
			echo "　　・{$l_0id}　<a href=\"./archive_swd.php?l_id={$l_0id}\">圧縮</a><br>\n";
		}
		echo "</details><br>\n";
	}
	
	foreach(glob("{$d_path}/{*.7z,*.zip}", GLOB_BRACE) as $fc){
		$f_name = basename($fc);
		echo "<a href=\"./dl_file_s.php?f_name=".rawurlencode($f_name)."\">{$f_name}</a><br>\n";
	}
?>
	<br><br>
	<a href="./admin.php">管理メニュー</a><br>
	<br><br>
</body>
</html>
