<!doctype html>
<?php
	require_once("./config.php");
	// 管理者によるなりすまし用
	if(isset($_GET['cls_id']) && ($_SESSION['grd_id'] == $GRD_ADM)){
		$cls_id = $_GET['cls_id'];
	}
	if(isset($_GET['u_id']) && ($_SESSION['grd_id'] == $GRD_ADM)){
		$u_id = $_GET['u_id'];
	}
	
	// DBへ接続
	try{
		$dbh = new PDO("mysql:host=localhost;dbname={$DB_NAME};charset=utf8mb4", $DB_USER, $DB_PW);
		$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}
	catch(PDOException $e){
		exit("DBへの接続に失敗しました．<br>");
	}
	
	// 課題情報の取得
	if(isset($_GET['l_id']) && isset($_GET['sub_id'])){
		$l_id   = $_GET['l_id'];
		$sub_id = $_GET['sub_id'];
		$sqlstr = "SELECT cls_id,l_id,t_open,t_late,p_id{$sub_id} FROM p_link WHERE cls_id={$cls_id} AND l_id={$l_id};";
		try{
			$result_PLINK = $dbh->query($sqlstr);
		}
		catch(PDOException $e){
			exit("課題情報の取得に失敗しました．<br>");
		}
		if($result_PLINK->rowCount() <= 0){
			exit("課題一覧内に該当する課題が見当たりません．<br>");
		}
		
		$data   = $result_PLINK->fetch(PDO::FETCH_ASSOC);
		$p_id   = $data['p_id'.$sub_id];
		$cls_id = $data['cls_id'];
		$l_id   = $data['l_id'];
		
		$sqlstr = sprintf("SELECT s%02d%d FROM evals WHERE u_id='%s';", $l_id, $sub_id, $u_id);
		try{
		$result_EVALS = $dbh->query($sqlstr);
		}
		catch(PDOException $e){
			exit("評価情報の取得に失敗しました．<br>");
		}
		if($result_EVALS !== FALSE){
			$data_e  = $result_EVALS->fetch(PDO::FETCH_ASSOC);
			$data_e2 = $data_e[sprintf("s%02d%d", $l_id, $sub_id)];
		}
	}
	elseif(isset($_GET['p_id'])){
		$p_id = $_GET['p_id'];
		$cls_id = 0;
		$l_id   = 0;
		$sub_id = 0;
		$data['t_open'] = "9999-99-99 99:99";
		$data['t_late'] = "0000-00-00 00:00";
		$data_e2 = 0;
	}
	else{
		exit("課題が指定されていません．<br>");
	}
	
	$sqlstr = "SELECT * FROM p_bank WHERE p_id={$p_id};";
	try{
		$result_PBANK = $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("課題バンク内に該当する課題が見当たりません．<br>");
	}
	$data_b = $result_PBANK->fetch(PDO::FETCH_ASSOC);
	
	$les_id = sprintf("%s%02d%d", mb_strtolower($LIST_CLS[$cls_id]), $l_id, $sub_id);
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta name="viewport" content="width=device-width,initial-scale=1.0">
	<title><?= $SV_TITLE; ?> 課題ページ</title>
	<link rel="stylesheet" type="text/css" href="base.css">
	<link rel="stylesheet" href="/js/highlight/styles/xcode.css">
</head>
<body>
<?php
	if($data_e2 == 7){
?>
	<div id="firework" style="position:fixed; top:0; left:0; z-index:-1;"></div>
	<script src="/js/p5.min.js"></script>
	<script src="/js/firework.js"></script>
<?php
	}
?>
	<h1><?= $SV_TITLE; ?></h1>
	<h2>課題ページ</h2>
	<table border="1">
<tr>
	<td>課題番号：</td>
	<td><?= $les_id; ?></td>
</tr>
<tr>
	<td>タイトル：</td>
	<td><?= htmlspecialchars($data_b['title']); ?></td>
</tr>
<tr><td>説明：</td><td><pre>
<?php
	$f_path = sprintf("%s_test/%04d/direction.txt", $PATH_SWD, $p_id);
	if(!file_exists($f_path)){
		$f_path = "{$PATH_SWD}_test/_default/direction{$data_b['type']}.txt";
	}
	echo str_replace("\$les_id", $les_id, file_get_contents($f_path));

	if($data_b['type'] == 3){
?>

※タイトルバーに学籍番号を含めないと，不合格になります．
※提出時に「あなたのプログラムの実行結果」が真っ黒だった場合は，
　プログラムファイルをもう一度提出してください．
<?php
	}
?>
</pre></td></tr>
<?php
	$f_path = sprintf("%s_test/%04d/code.txt", $PATH_SWD, $p_id);
	if(file_exists($f_path)){
		echo "<tr><td>コード：<br><input type=\"button\" value=\"コピー\" onClick=\"copyText();\"></td><td><pre><code id=\"draft_code\">";
		echo htmlspecialchars(str_replace("\$u_id", $u_id, file_get_contents($f_path)));
		echo "</code></pre></td></tr>";
	}
	$f_path = sprintf("%s_test/%04d/figure.png", $PATH_SWD, $p_id);
	if(file_exists($f_path)){
		echo "<tr><td>図：</td><td><img src=\"./disp_png.php?p_id={$p_id}\"></td></tr>\n";
	}
	if(!empty($data_b['dist'])){
		echo "<tr><td>配布物：</td><td><a href=\"./dl_file_d.php?p_id={$p_id}\">ダウンロード</a></td></tr>\n";
	}
	
	switch($data_b['type']){
	case 1:  // py,zipを受け取るのみ
	case 2:  // 自動採点
	case 3:  // GUIあり
		echo "<tr><td>プログラム<br>(py,zip)提出：</td><td><a href=\"./dl_file_u.php?l_id={$l_id}&sub_id={$sub_id}&ext=code\">提出ファイルの確認</a><br>";
		echo "<form action=\"./ul_code.php?p_id={$p_id}&l_id={$l_id}&sub_id={$sub_id}\" method=\"post\" enctype=\"multipart/form-data\" onSubmit=\"return dis_btn();\">\n";
		echo "<input name=\"file\" type=\"file\" accept=\".py,.pyw,.pyz,.zip\">";
		break;
	case 4:  // テキストを受け取るのみ
	case 5:  // 行ごとに自動採点
		echo "<tr><td>解答欄：</td><td><form action=\"./ul_text.php?p_id={$p_id}&l_id={$l_id}&sub_id={$sub_id}\" method=\"post\" enctype=\"multipart/form-data\">\n";
		echo "<textarea name=\"txt_a\" rows=\"20\" cols=\"80\">";
		$f_path = sprintf("%s%02d%d/%s/a.txt", $PATH_SWD, $l_id, $sub_id, $u_id);
		if(file_exists($f_path)){
			echo htmlspecialchars(file_get_contents($f_path));
		}
		echo "</textarea><br>";
		break;
	case 6:  // 画像を受け取るのみ
		echo "<tr><td>画像ファイル<br>(png)提出：</td><td>提出済みの画像<br><img src=\"./disp_png.php?l_id={$l_id}&sub_id={$sub_id}\"><br>\n";
		echo "<form action=\"./ul_file.php?p_id={$p_id}&l_id={$l_id}&sub_id={$sub_id}\" method=\"post\" enctype=\"multipart/form-data\">\n";
		echo "<input name=\"file\" type=\"file\" accept=\".png\">";
		break;
	case 7:  // ドキュメントを受け取るのみ
		echo "<tr><td>ドキュメント<br>提出：</td><td><a href=\"./dl_file_u.php?l_id={$l_id}&sub_id={$sub_id}\">提出ファイルの確認</a><br>";
		echo "<form action=\"./ul_file.php?p_id={$p_id}&l_id={$l_id}&sub_id={$sub_id}\" method=\"post\" enctype=\"multipart/form-data\">\n";
		echo "<input name=\"file\" type=\"file\" accept=\".doc,.docx,.pdf,.odt\">";
		break;
	case 8:  // zipを受け取るのみ
		echo "<tr><td>圧縮ファイル<br>(zip)提出：</td><td><a href=\"./dl_file_u.php?l_id={$l_id}&sub_id={$sub_id}\">提出ファイルの確認</a><br>";
		echo "<form action=\"./ul_file.php?p_id={$p_id}&l_id={$l_id}&sub_id={$sub_id}\" method=\"post\" enctype=\"multipart/form-data\">\n";
		echo "<input name=\"file\" type=\"file\" accept=\".zip\">";
		break;
	default:
		goto typezero;
	}
	
	echo "<input name=\"type\" type=\"hidden\" value=\"{$data_b['type']}\">\n";
	echo "<input name=\"t_late\" type=\"hidden\" value=\"{$data['t_late']}\">\n";
	$time_str = date("Y-m-d H:i", $time_now);
	if($time_str >= $data['t_open']){
		echo "<input type=\"submit\" name=\"submit\" value=\"提出\"></form></td></tr>\n";
	}
	else{
		echo "<input type=\"submit\" name=\"submit\" value=\"提出\" disabled=\"disabled\"></form>\n";
		echo "{$data['t_open']}以降に提出できます</td></tr>\n";
	}
typezero:
?>
<tr>
	<td>判定：</td>
	<td><?= $LIST_EVS[$data_e2]; ?></td>
</tr>
<?php
	$f_path = sprintf("%s%02d%d/%s/comment.txt", $PATH_SWD, $l_id, $sub_id, $u_id);
	if(file_exists($f_path)){
		echo "<tr bgcolor=\"#ffefef\"><td>コメント：</td><td><pre>".file_get_contents($f_path)."</pre></td></tr>\n";
	}
	$f_path = sprintf("%s_test/%04d/answer.txt", $PATH_SWD, $p_id);
	if(file_exists($f_path)){
		if($time_str >= $data['t_late']){
			echo "<tr onCopy=\"alert('コピー不可'); return false;\"><td>正解例：<br>コピー不可</td><td><pre><code>";
			if($data_b['type'] == 5){
				echo htmlspecialchars(preg_replace('/\t.*/', '', file_get_contents($f_path)));
			}
			else{
				echo htmlspecialchars(str_replace("\$u_id", $u_id, file_get_contents($f_path)));
			}
			echo "</code></pre></td></tr>\n";
		}
		else{
			echo "<tr><td>正解例：</td><td>{$data['t_late']}以降に公開されます</td></tr>\n";
		}
	}
	$f_path = sprintf("%s_test/%04d/answer.png", $PATH_SWD, $p_id);
	if(file_exists($f_path)){
		if($time_str >= $data['t_late']){
			echo "<tr onCopy=\"alert('コピー不可'); return false;\"><td>正解例：<br>コピー不可</td>";
			echo "<td><img src=\"./disp_png.php?p_id={$p_id}&f_name=answer.png\"></td></tr>\n";
		}
		else{
			echo "<tr><td>正解例：</td><td>{$data['t_late']}以降に公開されます</td></tr>\n";
		}
	}
	if(($data_b['type'] <= 3) && ($data_e2 > 0)){
?>
	</table>
	<br>
	<table border="1">
		<thead>
<tr><th>前回のプログラムの実行結果</th><th>正解プログラムの実行結果</th></tr>
		</thead>
		<tbody>
<?php
		// GUI起動画面用
		$f_path = sprintf("%s%02d%d/%s/ss_win.png", $PATH_SWD, $l_id, $sub_id, $u_id);
		if(file_exists($f_path)){
			echo "<tr><td class=\"t\"><img src=\"./disp_png.php?l_id={$l_id}&sub_id={$sub_id}&f_name=ss_win\" loading=\"lazy\"></td><td class=\"t\">";
			$f_path = sprintf("%s_test/%s/ss_win.png", $PATH_SWD, $p_id);
			if(file_exists($f_path)){
				echo "<img src=\"./disp_png.php?p_id={$p_id}&f_name=ss_win.png\" loading=\"lazy\">";
			}
			else{
				echo "正解例のスクリーンショットはありません．";
			}
			echo "</td></tr>\n";
		}

		$les_id = substr($les_id, 1);
		$fn = 0;
		foreach(glob(sprintf("%s_test/%04d/output*.dat", $PATH_SWD, $p_id)) as $fc){
?>
<tr>
<td class="t"><pre>
<?php
			echo "<p id=\"txt_u{$fn}\">";
			$fu = "{$PATH_SWD}{$les_id}/{$u_id}/".basename($fc);
			echo htmlspecialchars(file_get_contents($fu, length: 100000));
			echo "</p>";
?>
</pre></td>
<td class="t"><pre>
<?php
			echo "<p id=\"txt_c{$fn}\">";
			echo htmlspecialchars(file_get_contents($fc));
			echo "</p>";
?>
</pre></td>
</tr>
<?php
			$fn++;
		}
?>
		</tbody>
	</table>
	<script src="/js/jquery-3.min.js"></script>
	<script src="/js/diff_match_patch.js"></script>
	<script>
<!--
	window.addEventListener('load', function () {
		for(var i = 0; i < <?= $fn; ?>; i++){
			var txt_u = $('#txt_u' + i).text().replace(/\r?\n/g, '\n');
			var txt_c = $('#txt_c' + i).text().replace(/\r?\n/g, '\n');
			var dmp   = new diff_match_patch();
			var dif_u = dmp.diff_main(txt_c, txt_u);
			var dif_c = dmp.diff_main(txt_u, txt_c);
			$('#txt_u' + i).html( dmp.diff_prettyHtml(dif_u).replace("&para;", "") );
			$('#txt_c' + i).html( dmp.diff_prettyHtml(dif_c).replace("&para;", "") );
		}
	});
// -->
	</script>
	<b>注：入力は自動のため非表示</b><br>
	<br>
	<table border="1">
<tr><th colspan="2">自動採点用ログ</th></tr>
<?php
		foreach(glob("{$PATH_SWD}{$les_id}/{$u_id}/*.log") as $f1){
			if(filesize($f1) <= 0) continue;
?>
<tr>
<td class="t"><pre>
<?= htmlspecialchars(basename($f1)); ?>
</pre></td>
<td class="t"><pre>
<?= htmlspecialchars(file_get_contents($f1)); ?>
</pre></td>
</tr>
<?php
		}
	}
	else if(($data_b['type'] <= 5) && ($data_e2 > 0)){
		$les_id = substr($les_id, 1);
?>
	</table>
	<br>
	<table border="1">
		<thead>
<tr><th>誤箇所</th><th>前回の解答</th></tr>
		</thead>
		<tbody>
<tr>
<td class="t c"><pre><b><?= htmlspecialchars(file_get_contents("{$PATH_SWD}{$les_id}/{$u_id}/output.dat")); ?></b></pre></td>
<td class="t"><pre><?= htmlspecialchars(file_get_contents("{$PATH_SWD}{$les_id}/{$u_id}/a.txt")); ?></pre></td>
</tr>
		</tbody>
<?php
	}
?>
	</table>
	<br>
	<a href="./show_eu.php">課題一覧に戻る</a><br>
	<br><br>
	<script src="/js/highlight/highlight.pack.js"></script>
	<script>
<!--
	hljs.initHighlightingOnLoad();
	
	function copyText(){
		var dc = document.getElementById("draft_code");
		var ta = document.createElement("textarea");
		ta.value = dc.textContent;
		document.body.appendChild(ta);
		ta.select();
		document.execCommand("copy");
		ta.parentElement.removeChild(ta);
		alert("コードをコピーしました");
	}
	
	function dis_btn(){
		var e1 = document.getElementsByName("submit")[0];
		if(e1.disabled){
			return false;
		}
		else{
			e1.disabled = true;
			return true;
		}
	}
// -->
	</script>
</body>
</html>
