<!doctype html>
<?php
	require_once("./config.php");
	
	// DBへ接続
	try{
		$dbh = new PDO("mysql:host=localhost;dbname={$DB_NAME};charset=utf8mb4", $DB_USER, $DB_PW);
		$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}
	catch(PDOException $e){
		exit("DBへの接続に失敗しました．<br>");
	}
	
	// 授業設定情報の取得
	$sqlstr = "SELECT * FROM p_link WHERE cls_id={$cls_id} ORDER BY l_id;";
	try{
		$result_PLINK = $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("授業設定情報の取得に失敗しました．<br>");
	}
	
	// 課題情報の取得
	$sqlstr = "SELECT p_id,title,type FROM p_bank ORDER BY p_id;";
	try{
		$result_PBANK = $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("課題情報の取得に失敗しました．<br>");
	}
	
	$list_type_c = array("#ffffff","#ffbbbb","#bbffbb","#bbbbff");
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta name="viewport" content="width=device-width,initial-scale=1.0">
	<title><?= $SV_TITLE; ?> 授業情報の一覧ページ</title>
	<link rel="stylesheet" type="text/css" href="basea.css">
	<link rel="stylesheet" type="text/css" href="form.css">
</head>
<body>
	<h1><?= $SV_TITLE; ?></h1>
	<h2><?= $LIST_CLS[$cls_id]; ?>クラスの授業情報の一覧ページ</h2>
	<table border="1">
		<thead>
<tr>
	<th>授業</th><th>授業開始</th><th>課題公開</th><th>課題締切</th><th>教室IP</th><th>課題１</th><th>課題２</th><th>課題３</th><th>課題４</th><th>課題５</th><th>課題６</th><th>課題７</th><th>課題８</th>
</tr>
		</thead>
		<tbody>
<?php
	$l_id = 1;
	while($data = $result_PLINK->fetch(PDO::FETCH_ASSOC)){
		while($l_id < $data['l_id']){
			printf("<tr>\n<td class=\"c\"><a href=\"./edit_l.php?l_id=%d\">%02d</a></td>\n</tr>\n", $l_id, $l_id);
			$l_id++;
		}
		printf("<tr>\n<td class=\"c\"><a href=\"./edit_l.php?l_id=%d\">%02d</a></td><td>%s</td><td>%s</td><td>%s</td><td>%s/%d</td>", $l_id, $l_id, substr($data['t_open'], 5), substr($data['t_view'], 5), substr($data['t_late'], 5), long2ip($data['ip_int']), $data['ip_msk']);
		for($sub_id = 1; $sub_id <= 8; $sub_id++){
			$p_id = $data['p_id'.$sub_id];
			if($p_id == NULL)
				continue;
			printf("<td class=\"c\"><a href=\"./edit_p.php?p_id=%d\">%04d</a></td>\n", $p_id, $p_id);
		}
		printf("</tr>\n");
		$l_id++;
	}
	while($l_id <= 15){
		printf("<tr>\n<td class=\"c\"><a href=\"./edit_l.php?l_id=%d\">%02d</a></td>\n</tr>\n", $l_id, $l_id);
		$l_id++;
	}
?>
		</tbody>
	</table>
	<br>
	<a href="./admin.php">管理メニュー</a><br>
	<br><br>
</body>
</html>
