<!doctype html>
<?php
	require_once("./config.php");
	// 管理者によるなりすまし用
	if($_SESSION['grd_id'] == $GRD_ADM){
		if(isset($_GET['cls_id'])){
			$cls_id = $_GET['cls_id'];
		}
		if(isset($_GET['u_id'])){
			$u_id = $_GET['u_id'];
		}
	}
	
	// DBへ接続
	try{
		$dbh = new PDO("mysql:host=localhost;dbname={$DB_NAME};charset=utf8mb4", $DB_USER, $DB_PW);
		$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}
	catch(PDOException $e){
		exit("DBへの接続に失敗しました．<br>");
	}
	
	// 授業設定情報の取得
	$sqlstr = "SELECT * FROM p_link WHERE cls_id={$cls_id} ORDER BY l_id;";
	try{
		$result_PLINK = $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("授業設定情報の取得に失敗しました．<br>");
	}
	
	// 評価情報の取得
	$sqlstr = "SELECT * FROM evals WHERE u_id='{$u_id}';";
	try{
		$result_EVALS = $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("評価情報の取得に失敗しました．<br>");
	}
	if($result_EVALS->rowCount() == 0){
		exit("未登録ユーザです．<br>");
	}
	else{
		$data_e = $result_EVALS->fetch(PDO::FETCH_ASSOC);
	}
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta name="viewport" content="width=device-width,initial-scale=1.0">
	<title><?= $SV_TITLE; ?> 課題一覧ページ</title>
	<link rel="stylesheet" type="text/css" href="base.css">
	<link rel="stylesheet" type="text/css" href="form.css">
</head>
<body>
	<h1><?= $SV_TITLE; ?></h1>
	<h2><?= $LIST_CLS[$cls_id]; ?>クラスの課題一覧ページ</h2>
	<table border="1" id="table1">
		<thead>
<tr>
	<th>授業</th><th>締め切り</th><th>課題１</th><th>課題２</th><th>課題３</th><th>課題４</th><th>課題５</th><th>課題６</th><th>課題７</th><th>課題８</th><th>課題９</th>
</tr>
		</thead>
		<tbody>
<?php
	$time_str = date("Y-m-d H:i", $time_now);
	$l_id = 1;
	while($data = $result_PLINK->fetch(PDO::FETCH_ASSOC)){
		while($l_id < $data['l_id']){
			$l_id0d = sprintf("%02d", $l_id);
			$e_str  = $LIST_EVS[$data_e["s{$l_id0d}0"]];
			echo "<tr>\n<td class=\"c\">{$l_id0d}</td>\n</tr>\n";
			$l_id++;
		}
		if($time_str >= $data['t_view']){
			$l_id0d = sprintf("%02d", $l_id);
			$e_str  = $LIST_EVS[$data_e["s{$l_id0d}0"]];
			echo "<tr>\n<td class=\"c\">{$l_id0d}</td><td>{$data['t_late']}</td>\n";
			for($sub_id = 1; $sub_id <= 8; $sub_id++){
				if($data['p_id'.$sub_id] == NULL)
					continue;
				$e_str  = $LIST_EVS[$data_e["s{$l_id0d}{$sub_id}"]];
				echo "<td class=\"c\"><a href=\"./show_p.php?l_id={$l_id}&sub_id={$sub_id}\">{$e_str}</a></td>\n";
			}
			$e_str  = $LIST_EVS[$data_e["s{$l_id0d}9"]];
			echo "<td class=\"c\"><a href=\"./show_p9.php?l_id={$l_id}\">{$e_str}</a></td>\n</tr>\n";
		}
		$l_id++;
	}
?>
		</tbody>
	</table>
	<br>
	<table border="1">
		<tr><td>記号</td><td class="c">×</td><td class="c">▲</td><td class="c">●</td><td class="c">○</td><td class="c">◎</td></tr>
		<tr><td>評価</td><td>未提出</td><td>不合格</td><td>合格(遅刻)</td><td>合格</td><td>合格(加点)</td></tr>
		<tr><td colspan="5">課題の概算評点（約<?= round(100 * $RATE_EV); ?>点中）<br>あくまでも概算の値です<br>実際の評点とは異なります</td><td style="text-align: right; vartical-align: middle;"><span id="eval_total"></span>点</td></tr>
	</table>
	<br>
	<a href="./">トップページ</a><br>
	<br><br>
	<script src="/js/jquery-3.min.js"></script>
	<script>
<!--
	$(window).on('load', function(){
		var texts = "" + $('#table1').text();
		var eval3 = (texts.match(/●/g) || []).length;
		var eval4 = (texts.match(/○/g) || []).length;
		var eval5 = (texts.match(/確/g) || []).length;
		var eval6 = (texts.match(/◎/g) || []).length;
		var eval7 = (texts.match(/◇/g) || []).length;
		var e_ttl = (eval3 * 1.5 + eval4 * 2.0 + eval5 * 2.0/3.0 + eval6 * 3.0 + eval7 * 1.0) <?= "* ".$RATE_EV; ?>;
		$('#eval_total').text(e_ttl.toFixed(1));
	});
// -->
	</script>
</body>
</html>
