<!doctype html>
<?php
	require_once("./config.php");
	if(isset($_GET['cls_id'])){
		$cls_id = $_GET['cls_id'];
	}
	
	// DBへ接続
	try{
		$dbh = new PDO("mysql:host=localhost;dbname={$DB_NAME};charset=utf8mb4", $DB_USER, $DB_PW);
		$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}
	catch(PDOException $e){
		exit("DBへの接続に失敗しました．<br>");
	}
	
	// 評価情報の取得
	$sqlstr = "SELECT * FROM (SELECT u_id,u_name FROM users WHERE cls_id={$cls_id} ORDER BY u_id) AS cls_users INNER JOIN evals ON cls_users.u_id=evals.u_id;";
	try{
		$result_EVALS = $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("評価情報の取得に失敗しました．<br>");
	}
	
	$users = [];
	$evals = [];
	$cols  = [];
	while($data = $result_EVALS->fetch(PDO::FETCH_ASSOC)){
		$attend1 = FALSE;
		$u_id1 = $data['u_id'];
		$users[$u_id1] = $data['u_name'];
		foreach($data as $col1 => $data1){
			if($col1[0] !== "s") continue;
			switch($col1[3]){
				case "0":
					if($data1 > 0){
						$attend1 = TRUE;
					}
					if(in_array(mb_substr($col1,1,2), $LIST_ATT)){
						$cols[$col1] = 1;
						switch($data1){
							case 1:
								$evals[$u_id1][$col1] = -2.0;
								break;
							case 3:
								$evals[$u_id1][$col1] = -1.0;
								break;
							case 5:
								$evals[$u_id1][$col1] =  0.0;
								break;
							default:
								$evals[$u_id1][$col1] = -3.0;
								break;
						}
					}
					break;
				case "9":
					$cols[$col1] = 1;
					if($data1 >= 8){
						$evals[$u_id1][$col1] = 1.0;
					}
					elseif($attend1 && ($data1 >= 7)){
						$evals[$u_id1][$col1] = 0.5;
					}
					else{
						$evals[$u_id1][$col1] = 0.0;
					}
					$attend1 = FALSE;
					break;
				default:
					switch($data1){
						case 2:
						case 3:
						case 4:
							$evals[$u_id1][$col1] = 1.5;
							break;
						case 5:
							$evals[$u_id1][$col1] = 2.0;
							break;
						case 6:
							$evals[$u_id1][$col1] = 2.5;
							break;
						case 7:
							$evals[$u_id1][$col1] = 3.0;
							break;
						default:
							$evals[$u_id1][$col1] = 0.0;
							break;
					}
					@$cols[$col1] += $data1;
					break;
			}
		}
	}
	
	foreach($cols as $col1 => $data1){
		if($col1[0] !== "s") continue;
		if(!($data1 > 0)){
			unset($evals[$col1]);
			unset($cols[$col1]);
		}
	}
	ksort($cols);
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta name="viewport" content="width=device-width,initial-scale=1.0">
	<title><?= $SV_TITLE; ?> 評価の一覧ページ</title>
	<link rel="stylesheet" type="text/css" href="basea.css">
	<link rel="stylesheet" type="text/css" href="form.css">
</head>
<body>
	<h1><?= $SV_TITLE; ?></h1>
	<h2><?= $LIST_CLS[$cls_id]; ?>クラスの評価の一覧ページ</h2>
	<table border="1">
		<thead>
<tr><th>学籍番号</th><th>氏名</th><th>クラス</th>
<?php
	foreach($cols as $col1 => $data1){
		echo "<th>{$col1}</th>";
	}
?>
<th>合計</th></tr>
		</thead>
		<tbody>
<?php
	foreach($users as $u_id1 => $u_name){
		echo "<tr><td>".str_replace("m", " M", $u_id1)."</td><td>{$u_name}</td><td>{$LIST_CLS[$cls_id]}</td>";
		$sum = 0;
		foreach($cols as $col1 => $data1){
			echo "<td>{$evals[$u_id1][$col1]}</td>";
			$sum += $evals[$u_id1][$col1];
		}
		echo "<td>{$sum}</td></tr>\n";
	}
?>
		</tbody>
	</table>
	<br>
	<a href="./admin.php">管理メニュー</a><br>
	<br><br>
	<script src="/js/jquery-3.min.js"></script>
</body>
</html>
