<!doctype html>
<?php
	require_once("./config.php");
	if(isset($_GET['cls_id'])){
		$cls_id = $_GET['cls_id'];
	}
	if(isset($_GET['l_id'])){
		$l_id = $_GET['l_id'];
	}
	if(isset($_GET['sub_id'])){
		$sub_id = $_GET['sub_id'];
	}
	else{
		exit("課題が指定されていません．<br>");
	}
	if(isset($_GET['f_name'])){
		$f_name1 = $_GET['f_name'];
		$f_name2 = $_GET['f_name'];
	}
	else{
		$f_name1 = "resdiff.log";
		$f_name2 = "a.txt";
	}
	if(isset($_GET['all'])){
		$is_all = TRUE;
	}
	else{
		$is_all = FALSE;
	}
	
	// DBへ接続
	try{
		$dbh = new PDO("mysql:host=localhost;dbname={$DB_NAME};charset=utf8mb4", $DB_USER, $DB_PW);
		$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}
	catch(PDOException $e){
		exit("DBへの接続に失敗しました．<br>");
	}
	
	// 課題情報の取得
	$sqlstr = "SELECT p_id{$sub_id} FROM p_link WHERE cls_id={$cls_id} AND l_id={$l_id};";
	try{
		$result_PLINK = $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("課題情報の取得に失敗しました．<br>");
	}
	if($result_PLINK->rowsCount() <= 0){
		exit("課題一覧内に該当する課題が見当たりません．<br>");
	}
	
	$data   = $result_PLINK->fetch(PDO::FETCH_ASSOC);
	$p_id   = $data['p_id'.$sub_id];
	$l_id0d = sprintf("%02d", $l_id);
	$s_id   = "s".$l_id0d.$sub_id;
	
	$sqlstr = "SELECT * FROM p_bank WHERE p_id={$p_id};";
	try{
		$result_PBANK = $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("課題バンク内に該当する課題が見当たりません．<br>");
	}
	$data_b = $result_PBANK->fetch(PDO::FETCH_ASSOC);
	
	// ユーザ情報の取得
	$sqlstr = "SELECT * FROM (SELECT u_id FROM users WHERE cls_id={$cls_id}) AS u1 INNER JOIN (SELECT u_id,{$s_id} FROM evals) AS e1 ON u1.u_id = e1.u_id;";
	try{
		$result_USERS= $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("ユーザ情報の取得に失敗しました．<br>");
	}
	
	$LIST_EVS = ["×", "▲", "確1", "●", "○", "確2", "◎", "多"];
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta name="viewport" content="width=device-width,initial-scale=1.0">
	<title><?= $SV_TITLE; ?> 課題の解答一覧ページ</title>
	<link rel="stylesheet" type="text/css" href="basea.css">
	<link rel="stylesheet" type="text/css" href="form.css">
</head>
<body>
	<h1><?= $SV_TITLE; ?></h1>
	<h2><?= "{$LIST_CLS[$cls_id]}クラス第{$l_id0d}回課題{$sub_id}"; ?>の解答一覧ページ</h2>
	<form action="./update_e.php" method="post" enctype="multipart/form-data">
		<table border="1">
<tr>
	<td>課題番号：</td><td></td>
	<td><?= mb_strtolower($LIST_CLS[$cls_id]).$l_id0d.$sub_id; ?></td>
</tr>
<tr>
	<td>タイトル：</td><td></td>
	<td><?= htmlspecialchars($data_b['title']); ?></td>
</tr>
<?php
	while($data = $result_USERS->fetch(PDO::FETCH_ASSOC)){
		echo "<tr><td>{$data['u_id']}</td><td>{$LIST_EVS[$data[$s_id]]}</td>\n";
		switch($data_b['type']){
		case 1:  // JARを受け取るのみ
		case 2:  // 自動採点
		case 3:  // JavaFX用
			echo "<td><pre><code><a href=\"./dl_file_u.php?l_id={$l_id}&sub_id={$sub_id}&u_id={$data['u_id']}&ext=jar\">提出ファイルの確認</a>\n";
			$f_path = "{$PATH_SWD}{$l_id0d}{$sub_id}/{$data['u_id']}/{$f_name1}";
			if(file_exists($f_path)){
				echo htmlspecialchars(file_get_contents($f_path));
			}
			echo "</code></pre>";
			$f_path = "{$PATH_SWD}{$l_id0d}{$sub_id}/{$data['u_id']}/a.png";
			if(($data[$s_id] == 2) || ($data[$s_id] == 5) || $is_all){
				echo "<img src=\"./disp_png.php?l_id={$l_id}&sub_id={$sub_id}&u_id={$data['u_id']}\">";
			}
			echo "</td>";
			break;
		case 4:  // テキストを受け取るのみ
		case 5:  // 行ごとに自動採点
			echo "<td><pre><code>";
			$f_path = "{$PATH_SWD}{$l_id0d}{$sub_id}/{$data['u_id']}/{$f_name2}";
			if(file_exists($f_path)){
				echo htmlspecialchars(file_get_contents($f_path));
			}
			echo "</code></pre></td>";
			break;
		case 6:  // 画像を受け取るのみ
			if(($data[$s_id] == 2) || ($data[$s_id] == 5) || $is_all){
				echo "<td><img src=\"./disp_png.php?l_id={$l_id}&sub_id={$sub_id}&u_id={$data['u_id']}\"></td>";
			}
			break;
		case 7:  // ドキュメントを受け取るのみ
		case 8:  // ZIPを受け取るのみ
			echo "<td><pre><code><a href=\"./dl_file_u.php?l_id={$l_id}&sub_id={$sub_id}&u_id={$data['u_id']}\">提出ファイルの確認</a>\n";
			break;
		}
		echo "</tr>\n";
	}
?>
		</table>
	</form>
	<br>
	<a href="./edit_ls.php">戻る</a><br>
	<br><br>
	<script src="/js/jquery-3.min.js"></script>
</body>
</html>
