<!doctype html>
<?php
	require_once("./config.php");
	if(isset($_GET['cls_id'])){
		$cls_id = $_GET['cls_id'];
	}
	if(isset($_GET['l_id'])){
		$l_id = $_GET['l_id'];
	}
	if(isset($_GET['sub_id'])){
		$sub_id = $_GET['sub_id'];
	}
	else{
		exit("課題が指定されていません．<br>");
	}
	if(isset($_GET['f_name'])){
		$f_name1 = $_GET['f_name'];
		$f_name2 = $_GET['f_name'];
	}
	else{
		$f_name1 = "resdiff.log";
		$f_name2 = "a.txt";
	}
	if(isset($_GET['all'])){
		$is_all = TRUE;
	}
	else{
		$is_all = FALSE;
	}
		
	// DBへ接続
	try{
		$dbh = new PDO("mysql:host=localhost;dbname={$DB_NAME};charset=utf8mb4", $DB_USER, $DB_PW);
		$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}
	catch(PDOException $e){
		exit("DBへの接続に失敗しました．<br>");
	}
	
	// 授業設定情報の取得
	$sqlstr = "SELECT p_id{$sub_id} FROM p_link WHERE cls_id={$cls_id} AND l_id={$l_id};";
	try{
		$result_PLINK = $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("授業設定情報の取得に失敗しました．<br>");
	}
	if($result_PLINK->rowCount() <= 0){
		exit("課題一覧内に該当する課題が見当たりません．<br>");
	}
	
	$data   = $result_PLINK->fetch(PDO::FETCH_ASSOC);
	$p_id   = $data['p_id'.$sub_id];
	$l_id0d = sprintf("%02d", $l_id);
	$slid   = "s".$l_id0d;
	$s_id   = $slid.$sub_id;
	
	// 課題バンク内の検索
	$sqlstr = "SELECT * FROM p_bank WHERE p_id={$p_id};";
	try{
		$result_PBANK = $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("課題バンク内に該当する課題が見当たりません．<br>");
	}
	$data_b = $result_PBANK->fetch(PDO::FETCH_ASSOC);
	
	// ユーザ情報の取得
	$sqlstr = "SELECT * FROM (SELECT u_id FROM users WHERE cls_id={$cls_id}) AS u1 INNER JOIN (SELECT u_id,{$s_id} FROM evals) AS e1 ON u1.u_id = e1.u_id;";
	try{
		$result_USERS = $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("ユーザ情報の取得に失敗しました．<br>");
	}
	
	$list_eva_opt = [];
	$num_eva = count($LIST_EVA);
	for($i = 0; $i <= $num_eva; $i++){
		foreach($LIST_EVA as $key => $val){
			$list_eva_opt[$i] .= "<option value=\"{$key}\"";
			if($key == $i){
				$list_eva_opt[$i] .= " selected";
			}
			$list_eva_opt[$i] .= ">{$val}</option>\n";
		}
		unset($val);
	}
	$list_eva_opt[$num_eva] = "<option value=\"\" selected></option>\n".$list_eva_opt[$num_eva];
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta name="viewport" content="width=device-width,initial-scale=1.0">
	<title><?= $SV_TITLE; ?> 課題の答案一覧ページ</title>
	<link rel="stylesheet" type="text/css" href="basea.css">
	<link rel="stylesheet" type="text/css" href="form.css">
	<style> textarea {field-sizing:content; min-width:20em} </style>
</head>
<body>
	<h1><?= $SV_TITLE; ?></h1>
	<h2><?= "{$LIST_CLS[$cls_id]}クラス第{$l_id0d}回課題{$sub_id}"; ?>の答案一覧ページ</h2>
	課題番号：<?= mb_strtolower($LIST_CLS[$cls_id]).$l_id0d.$sub_id; ?><br>
	タイトル：<?= htmlspecialchars($data_b['title']); ?><br>
	<form id="form1" action="./update_es.php" method="post" enctype="multipart/form-data">
		<table border="1">
			<thead>
<tr>
	<th class="c">更新</th><th class="sort_key">学籍番号</th><th class="c sort_key_rev">評価</th><th>ファイル</th><th>コメント</th>
</tr>
<tr>
	<td class="c"><input name="cb_all" type="checkbox" onClick="chk_all(this);"></td><td>すべて</td><td class="c"><select class="filter_sel" size="1"><?= $list_eva_opt[$num_eva] ?></select></td><td colspan="2">
<?php
	if($data_b['type'] == 3 || $data_b['type'] == 6){
?>
	画像 <span onClick="ch_params('_chk');">確</span>,<span onClick="ch_params('_all');">全</span> || 
<?php
	}
?>
	文字列 <span onClick="ch_params();">無</span> | 
<?php
	switch($data_b['type']){
	case 1:
	case 2:
	case 3:
		$str_dat = "";
		$str_pc  = "";
		for($i = 1; $i <= 5; $i++){
			$str_dat .= ",<span onClick=\"ch_params('output{$i}.dat');\">{$i}</span>";
			$str_pc  .= ",<span onClick=\"ch_params('output_pc{$i}.txt');\">{$i}</span>";
		}
?>
	<span onClick="ch_params('myapp.py');">py</span>
	 | dat <span onClick="ch_params('output.dat');">0</span><?= $str_dat ?>
	 | pc <span onClick="ch_params('output_pc.txt');">0</span><?= $str_pc ?>
<?php
		break;
	case 4:
	case 5:
?>
	<span onClick="ch_params('a.txt');">txt</span>
<?php
		break;
	}
?>
	 | <span onClick="ch_params('error.log');">err</span></td>
	</td>
</tr>
		</thead>
		<tbody class="sort_area filter_area">
<?php
	while($data = $result_USERS->fetch(PDO::FETCH_ASSOC)){
		$id = $data['u_id'];
		echo "<tr>";
		echo "<td class=\"c\"><input name=\"cb[{$id}]\" type=\"checkbox\" value=\"{$id}\" onClick=\"tgl_dis('{$id}');\" class=\"cb\"></td><td>{$id}</td>\n";
		echo "<td class=\"c\" data-key=\"{$data[$slid.$sub_id]}\"><select name=\"p{$sub_id}[{$id}]\" size=\"1\" disabled=\"disabled\">\n".$list_eva_opt[$data[$slid.$sub_id]]."</select></td>\n";
		echo "<td>";
		switch($data_b['type']){
		case 1:  // プログラムを受け取るのみ
		case 2:  // 自動採点
		case 3:  // GUI用
			echo "<pre><code><a href=\"./dl_file_u.php?l_id={$l_id}&sub_id={$sub_id}&u_id={$id}&ext=code\">提出ファイルの確認</a>\n";
			$f_path = "{$PATH_SWD}{$l_id0d}{$sub_id}/{$id}/{$f_name1}";
			if(file_exists($f_path)){
				echo htmlspecialchars(file_get_contents($f_path));
			}
			echo "</code></pre>";
			$f_path = "{$PATH_SWD}{$l_id0d}{$sub_id}/{$id}/ss_win.png";
			if(file_exists($f_path) && ((strpos($LIST_EVS[$data[$s_id]], "確") !== false) || $is_all)){
				echo "<img src=\"./disp_png.php?l_id={$l_id}&sub_id={$sub_id}&u_id={$id}&f_name=ss_win\" loading=\"lazy\">";
				$f_path = sprintf("%s_test/%s/ss_win.png", $PATH_SWD, $p_id);
				if(file_exists($f_path)){
					echo "　<img src=\"./disp_png.php?p_id={$p_id}&f_name=ss_win.png&u_id={$id}\" loading=\"lazy\">";
				}
				else{
					echo "正解例はありません．";
				}
			}
			break;
		case 4:  // テキストを受け取るのみ
		case 5:  // 行ごとに自動採点
			echo "<pre><code>";
			$f_path = "{$PATH_SWD}{$l_id0d}{$sub_id}/{$id}/{$f_name2}";
			if(file_exists($f_path)){
				echo htmlspecialchars(file_get_contents($f_path));
			}
			echo "</code></pre>";
			break;
		case 6:  // 画像を受け取るのみ
			if(($data[$s_id] == 2) || ($data[$s_id] == 5) || $is_all){
				echo "<img src=\"./disp_png.php?l_id={$l_id}&sub_id={$sub_id}&u_id={$id}\">";
			}
			break;
		case 7:  // ドキュメントを受け取るのみ
		case 8:  // ZIPを受け取るのみ
			echo "<a href=\"./dl_file_u.php?l_id={$l_id}&sub_id={$sub_id}&u_id={$id}\">提出ファイルの確認</a>";
			break;
		}
		echo "</td>\n";
		echo "<td><textarea name=\"txt_a{$sub_id}[{$id}]\" disabled=\"disabled\">";
		$f_path = "{$PATH_SWD}{$l_id0d}{$sub_id}/{$id}/comment.txt";
		if(file_exists($f_path)){
			echo htmlspecialchars(file_get_contents($f_path));
		}
		echo "</textarea></td>\n";
		echo "</tr>\n";
	}
?>
			</tbody>
			<tfoot>
<tr><td></td>
<td colspan="3"><input name="l_id" type="hidden" value="<?= $l_id; ?>"><input type="submit" name="submit" value="上記の内容で更新"></td>
			</tfoot>
		</table>
	</form>
	<br>
	<a href="./show_ls.php">戻る</a><br>
	<br><br>
	<script src="/js/jquery-3.min.js"></script>
	<script src="/js/mouri_common.js"></script>
	<script src="/js/sort_filter_table.js"></script>
	<script>
<!--
	window.onpageshow = clear_cb;

	function ch_params(v){
		const params = new URLSearchParams(window.location.search);
		if(v === undefined){
			params.delete("f_name");
		}
		else if(v == "_all"){
			params.set("all", "");
		}
		else if(v == "_chk"){
			params.delete("all");
		}
		else{
			params.set("f_name", v);
		}
		window.location.search = params.toString();
	}
// -->
	</script>
</body>
</html>
