<!doctype html>
<?php
	require_once("./config.php");
	
	// DBへ接続
	try{
		$dbh = new PDO("mysql:host=localhost;dbname={$DB_NAME};charset=utf8mb4", $DB_USER, $DB_PW);
		$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}
	catch(PDOException $e){
		exit("DBへの接続に失敗しました．<br>");
	}
	
	// ユーザ情報の取得
	$sqlstr = "SELECT u_id,u_name,u_yomi,cls_id,grd_id,e_mail FROM users ORDER BY cls_id,grd_id DESC,u_id;";
	try{
		$result_USERS = $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("ユーザ情報の取得に失敗しました．<br>");
	}
	
	// 所属のドロップダウンリストの生成
	$num_cls = count($LIST_CLS);
	$list_cls_opt = array_fill(0, $num_cls+1, "");
	for($i = 0; $i <= $num_cls; $i++){
		$list_cls_opt[$i] = "\n";
		foreach($LIST_CLS as $key => $val){
			$list_cls_opt[$i] .= "<option value=\"{$key}\"";
			if($key == $i){
				$list_cls_opt[$i] .= " selected";
			}
			$list_cls_opt[$i] .= ">{$val}</option>\n";
		}
		unset($val);
	}
	$list_cls_opt[$num_cls] = "<option value=\"all\" selected>すべて</option>\n".$list_cls_opt[$num_cls];
	
	// 等級のドロップダウンリストの生成
	$num_grd = count($LIST_GRD);
	$list_grd_opt = array_fill(0, $num_grd+1, "");
	for($i = 0; $i <= $num_grd; $i++){
		$list_grd_opt[$i] = "\n";
		foreach($LIST_GRD as $key => $val){
			$list_grd_opt[$i] .= "<option value=\"{$key}\"";
			if($key == $i){
				$list_grd_opt[$i] .= " selected";
			}
			$list_grd_opt[$i] .= ">{$val}</option>\n";
		}
		unset($val);
	}
	$list_grd_opt[$num_grd] = "<option value=\"\" selected></option>\n".$list_grd_opt[$num_grd];
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta name="viewport" content="width=device-width,initial-scale=1.0">
	<title><?= $SV_TITLE; ?> ユーザ情報の管理ページ</title>
	<link rel="stylesheet" type="text/css" href="basea.css">
	<link rel="stylesheet" type="text/css" href="form.css">
</head>
<body>
	<h1><?= $SV_TITLE; ?></h1>
	<h2>ユーザ情報の管理ページ</h2>
	<form action="./update_us.php" method="post" enctype="multipart/form-data">
		<table border="1">
			<thead>
<tr>
	<th class="c">更新</th><th width="120">ユーザID</th><th width="120">氏名</th><th width="180">ヨミ</th><th>所属</th><th>等級</th><th>e_mail</th><th>PW初期化</th><th>削除</th>
</tr>
<tr>
	<td class="c"></td><td></td><td></td><td></td><td><select class="filter_sel"><?= $list_cls_opt[$num_cls]; ?></select></td><td><select class="filter_sel"><?= $list_grd_opt[$num_grd]; ?></select></td>
</tr>
			</thead>
			<tbody class="sort_area filter_area">
<?php
	while($data = $result_USERS->fetch(PDO::FETCH_ASSOC)){
		$id = $data['u_id'];
?>
<tr>
<td class="c"><input name="cb[<?= $id; ?>]" type="checkbox" value="<?= $id; ?>" onClick="tgl_dis('<?= $id; ?>');"></td>
<td><input name="u_id[<?= $id; ?>]"   type="text" value="<?= $id; ?>" disabled="disabled"></td>
<td><input name="u_name[<?= $id; ?>]" type="text" value="<?= $data['u_name']; ?>" disabled="disabled"></td>
<td><input name="u_yomi[<?= $id; ?>]" type="text" value="<?= $data['u_yomi']; ?>" disabled="disabled"></td>
<td><select name="cls_id[<?= $id; ?>]" size="1" disabled="disabled"><?= $list_cls_opt[$data['cls_id']]; ?></select></td>
<td><select name="grd_id[<?= $id; ?>]" size="1" disabled="disabled"><?= $list_grd_opt[$data['grd_id']]; ?></select></td>
<td><input name="e_mail[<?= $id; ?>]" type="text" value="<?= $data['e_mail']; ?>" disabled="disabled"></td>
<td><input name="pwrs[<?= $id; ?>]" type="button" value="PW初期化" onClick="cfm_pwrs('<?= $id; ?>');" disabled="disabled"></td>
<td><input name="rm_u[<?= $id; ?>]" type="button" value="削除" onClick="cfm_rm_u('<?= $id; ?>');" disabled="disabled"></td>
</tr>
<?php
	}
?>
			</tbody>
			<tfoot>
<tr>
<td class="c"><input name="cb[-1]" type="checkbox" value="-1" onClick="tgl_dis('-1');"></td>
<td><input name="u_id[-1]"   type="text" value="" disabled="disabled"></td>
<td><input name="u_name[-1]" type="text" value="" disabled="disabled"></td>
<td><input name="u_yomi[-1]" type="text" value="" disabled="disabled"></td>
<td><select name="cls_id[-1]" size="1" disabled="disabled"><?= $list_cls_opt[0]; ?></select></td>
<td><select name="grd_id[-1]" size="1" disabled="disabled"><?= $list_grd_opt[0]; ?></select></td>
<td><input name="e_mail[-1]" type="text" value="" disabled="disabled"></td>
<td></td><td></td>
</tr>
			</tfoot>
		</table><br>
		<input type="submit" name="submit" value="上記の内容で更新"><br>
	</form>
	<br><br>
	<a href="./admin.php">管理メニュー</a><br>
	<br><br>
	<script src="/js/jquery-3.min.js"></script>
	<script src="/js/mouri_common.js"></script>
	<script src="/js/sort_filter_table.js"></script>
	<script>
<!--
	window.onpageshow = clear_cb;
// -->
	</script>
</body>
</html>
