<!doctype html>
<?php
	require_once("./config.php");
	if(isset($_GET['l_id'])){
		$l_id = $_GET['l_id'];
	}
	if(isset($_GET['cls_id'])){
		$cls_id = $_GET['cls_id'];
	}
	if(isset($_GET['copy_from'])){
		$copy_from = $_GET['copy_from'];
	}
	else{
		$copy_from = $cls_id;
	}
	
	// DBへ接続
	try{
		$dbh = new PDO("mysql:host=localhost;dbname={$DB_NAME};charset=utf8mb4", $DB_USER, $DB_PW);
		$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}
	catch(PDOException $e){
		exit("DBへの接続に失敗しました．<br>");
	}
	
	// 課題リンク情報の取得
	$sqlstr = "SELECT * FROM p_link WHERE l_id={$l_id} AND cls_id={$copy_from};";
	try{
		$result_PLINK = $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("課題リンク情報の取得に失敗しました．<br>");
	}
	$data = $result_PLINK->fetch(PDO::FETCH_ASSOC);
	$data_js = "";
	for($sub_id = 1; $sub_id <= 8; $sub_id++){
		$data_js .= sprintf("\"%d\":\"%d\",", $sub_id, @$data['p_id'.$sub_id]);
	}
	$data_js = rtrim($data_js, ",");
	
	// 課題情報の取得
	$sqlstr = "SELECT p_id,title,type FROM p_bank ORDER BY p_id;";
	try{
		$result_PBANK = $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("課題リンク情報の取得に失敗しました．<br>");
	}
	$optstr = "<option value=\"NULL\">0000: 未設定</option>";
	while($data_b = $result_PBANK->fetch(PDO::FETCH_ASSOC)){
		$optstr .= sprintf("<option value=\"%d\">%04d: %s</option>", $data_b['p_id'], $data_b['p_id'], $data_b['title']);
	}
	
	$LIST_COLOR = ["#ffffff","#ffbbbb","#bbffbb","#bbbbff"];
	
	$optstr_cls = "";
	foreach($LIST_CLS as $key => $val){
		$optstr_cls .= "<option value=\"{$key}\">{$val}</option>\n";
	}
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta name="viewport" content="width=device-width,initial-scale=1.0">
	<title><?= $SV_TITLE; ?> 授業設定ページ</title>
	<link rel="stylesheet" type="text/css" href="basea.css">
	<link rel="stylesheet" type="text/css" href="form.css">

</head>
<body>
	<h1><?= $SV_TITLE; ?></h1>
	<h2><?php printf("%sクラス第%02d回", $LIST_CLS[$cls_id], $l_id); ?>の授業設定ページ</h2>
	<form id="form1" action="./update_l.php" method="post" enctype="multipart/form-data" onSubmit="return replace_t();">
		<table border="1">
<?php
	$t_view = explode(" ", @$data['t_view']);
	$t_open = explode(" ", @$data['t_open']);
	$t_late = explode(" ", @$data['t_late']);
	if($cls_id != $copy_from){
		$t_open[1] = $LIST_DLT[$cls_id];
	}
?>
<tr><td class="c">授業開始</td><td><input name="t_open"     type="date"     value="<?= @$t_open[0]; ?>"><input type="time" step="300" name="t_open" value="<?= @$t_open[1]; ?>"><input type="hidden" name="t_open" value=""></td></tr>
<tr><td class="c">課題公開</td><td><input name="cb[t_view]" type="checkbox" value="t_view" onClick="tgl_dis('t_view');"><input type="date" name="t_view" value="<?= @$t_view[0]; ?>" disabled="disabled"><input type="time" name="t_view" value="<?= @$t_view[1]; ?>" disabled="disabled"><input type="hidden" name="t_view" value="" disabled="disabled"></td></tr>
<tr><td class="c">課題締切</td><td><input name="cb[t_late]" type="checkbox" value="t_late" onClick="tgl_dis('t_late');"><input type="date" name="t_late" value="<?= @$t_late[0]; ?>" disabled="disabled"><input type="time" name="t_late" value="<?= @$t_late[1]; ?>" disabled="disabled"><input type="hidden" name="t_late" value="" disabled="disabled"></td></tr>
<tr><td class="c">教室CIDR</td><td><input name="cidr"       type="text"     value="<?= long2ip(@$data['ip_int']).'/'.@$data['ip_msk']; ?>"></td></tr>
<?php
	for($sub_id = 1; $sub_id <= 8; $sub_id++){
		echo "<tr>\n<td class=\"c\"><a href=\"./show_p.php?l_id={$l_id}&sub_id={$sub_id}\">{$sub_id}</a></td>\n";
		echo "<td><select name=\"p_id[{$sub_id}]\" id=\"p_id[{$sub_id}]\">\n{$optstr}</select></td>\n";
		echo "<td><input type=\"button\" name=view[{$sub_id}] value=\"試見\" onClick=\"peep_p({$sub_id})\"></td></tr>\n";
	}
?>
<tr><td class="c"><a href="./show_p9.php?l_id=<?= $l_id; ?>">9</a></td><td><a href="read_p9.php?l_id=<?= $l_id; ?>" target="_blank">感想</a>　<a href="edit_el.php?l_id=<?= $l_id; ?>" target="_blank">評価</a>　<select name="copy_from"><?= $optstr_cls; ?></select>クラスの授業設定を<input type="button" onClick="copy_settings();" value="コピー"></td></tr>
<tr><td><input type="hidden" name="l_id" value="<?= $l_id; ?>"><input type="hidden" name="cls_id" value="<?= $cls_id; ?>"></td><td><input type="submit" value="上記で設定"></td></tr>
		</table>
	</form>
	<br>
	<a href="./show_ls.php">戻る</a><br>
	<br><br>
	<script src="/js/mouri_common.js"></script>
	<script>
<!--
	// 日時文字列のフォーマット
	function fmt_time(str){
		var str_a = str.split(/[- :,\.\/]/g);
		str = "";
		
		for(var i = 0; i < str_a.length; i++){
			if(str_a[i].length == 1){
				str_a[i] = "0" + str_a[i];
			}
			str = str + str_a[i];
		}
		str.replace(/[^0-9]/g, '');
		var str_t = str.slice(0, 4) + "-" + str.slice(4, 6) + "-" + str.slice(6, 8) + " " + str.slice(8, 10) + ":" + str.slice(10, 12);
		if(str_t == "-- :"){
			return "";
		}
		return str_t;
	}
	
	// 送信用日時文字列の作成
	function replace_t(){
		var t0, t1, t2;
		var f1 = document.forms["form1"];
		
		t0 = f1.elements["t_open"][0];
		t1 = f1.elements["t_open"][1];
		t2 = f1.elements["t_open"][2];
		t2.value = fmt_time(t0.value + " " + t1.value);
		
		if(f1.elements["cb[t_view]"].checked){
			t0 = f1.elements["t_view"][0];
			t1 = f1.elements["t_view"][1];
			t2 = f1.elements["t_view"][2];
			t2.value = fmt_time(t0.value + " " + t1.value);
		}
		
		if(f1.elements["cb[t_late]"].checked){
			t0 = f1.elements["t_late"][0];
			t1 = f1.elements["t_late"][1];
			t2 = f1.elements["t_late"][2];
			t2.value = fmt_time(t0.value + " " + t1.value);
		}
	}
	
	// 課題の試し見
	function peep_p(sub_id){
		var f1 = document.forms["form1"];
		var p_id = f1.elements["p_id[" + sub_id + "]"].value;
		
		if(p_id > 0){
			window.open("./show_p.php?p_id=" + p_id);
		}
		else{
			window.alert("課題が指定されていません．");
		}
	}
	
	// 他クラスから授業設定をコピー（時刻以外）
	function copy_settings(){
		var f1 = document.forms["form1"];
		var cls_id = f1.elements["copy_from"].value;
		
		const params = new URLSearchParams(window.location.search);
		params.set("copy_from", cls_id);
		window.location.search = params.toString();
	}
	
	function load_init(){
		var now = new Date();
		var t0, t1;
		var f1 = document.forms["form1"];
		
		t0 = f1.elements["t_view"][0];
		t1 = f1.elements["t_view"][1];
		if(t0.value == ""){
			t0.value = now.getFullYear() + "-" + ("0" + (now.getMonth() + 1)).slice(-2) + "-" + ("0" + now.getDate()).slice(-2);
		}
		if(t1.value == ""){
			t1.value = "00:00";
		}
		
		t0 = f1.elements["t_open"][0];
		t1 = f1.elements["t_open"][1];
		if(t0.value == ""){
			t0.value = now.getFullYear() + "-" + ("0" + (now.getMonth() + 1)).slice(-2) + "-" + ("0" + now.getDate()).slice(-2);
		}
		if(t1.value == ""){
			t1.value = "<?= $LIST_DLT[$cls_id]; ?>";
		}
		
		t0 = f1.elements["t_late"][0];
		t1 = f1.elements["t_late"][1];
		if(t0.value == ""){
			t0.value = now.getFullYear() + "-" + ("0" + (now.getMonth() + 1)).slice(-2) + "-" + ("0" + now.getDate()).slice(-2);
		}
		if(t1.value == ""){
			t1.value = "21:00";
		}
		
		var cidr = f1.elements["cidr"];
		if(cidr.value == "0.0.0.0/"){
			cidr.value = "<?= $CIDR_DEF; ?>";
		}
		
		var data_js = {<?= $data_js; ?>};
		for(sub_id = 1; sub_id <= 8; sub_id++){
			var s1 = document.getElementById("p_id["+sub_id+"]").getElementsByTagName('option');
			for(i = 0; i < s1.length; i++){
				if(s1[i].value == data_js[sub_id]){
					s1[i].selected = true;
					break;
				}
			}
		}
	}
	window.onload = load_init;
// -->
	</script>
</body>
</html>
