<!doctype html>
<?php
	require_once("./config.php");
	if(isset($_GET['cls_id'])){
		$cls_id = $_GET['cls_id'];
	}
	$l_id = $_GET['l_id'];
	
	// DBへ接続
	try{
		$dbh = new PDO("mysql:host=localhost;dbname={$DB_NAME};charset=utf8mb4", $DB_USER, $DB_PW);
		$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}
	catch(PDOException $e){
		exit("DBへの接続に失敗しました．<br>");
	}
	
	// 課題リンク情報の取得
	$slid = sprintf("s%02d", $l_id);
	$sqlstr = sprintf("SELECT * from p_link WHERE lnk_id=%d%02d;", $cls_id, $l_id);
	try{
		$result_PLINK = $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("課題リンク情報の取得に失敗しました．<br>");
	}
	$data_p = $result_PLINK->fetch(PDO::FETCH_ASSOC);
	$s_str = $slid."0,";
	$sub_max = 0;
	for($sub_id = 1; $sub_id <= 8; $sub_id++){
		if($data_p['p_id'.$sub_id] != NULL){
			$s_str .= $slid.$sub_id.",";
			$sub_max = $sub_id;
		}
	}
	
	// 評価情報の取得
	$sqlstr = "SELECT evals.u_id,u_name,{$s_str}{$slid}9 FROM (SELECT u_id,u_name FROM users WHERE cls_id={$cls_id}) AS cls_users INNER JOIN evals ON cls_users.u_id=evals.u_id;";
	try{
		$result_EVALS = $dbh->query($sqlstr);
	}
	catch(PDOException $e){
		exit("評価情報の取得に失敗しました．<br>");
	}
	
	$list_eva_opt = array_fill(0, count($LIST_EVA), "");
	for($i = 0; $i < count($LIST_EVA); $i++){
		foreach($LIST_EVA as $key => $val){
			$list_eva_opt[$i] .= "<option value=\"{$key}\"";
			if($key == $i){
				$list_eva_opt[$i] .= " selected";
			}
			$list_eva_opt[$i] .= ">{$val}</option>\n";
		}
		unset($val);
	}
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta name="viewport" content="width=device-width,initial-scale=1.0">
	<title><?= $SV_TITLE; ?> 評価の管理ページ</title>
	<link rel="stylesheet" type="text/css" href="basea.css">
	<link rel="stylesheet" type="text/css" href="form.css">
</head>
<body>
	<h1><?= $SV_TITLE; ?></h1>
	<h2><?php printf("%sクラス第%02d回の", $LIST_CLS[$cls_id], $l_id); ?>評価の管理ページ</h2>
	<form id="form1" action="./update_es.php" method="post" enctype="multipart/form-data">
		<table border="1">
			<thead>
<tr><th><input name="l_id" type="hidden" value="<?= $l_id; ?>">更新</th><th>学籍番号</th><th>氏名</th><th>出席</th>
<?php
	for($sub_id = 1; $sub_id <= $sub_max; $sub_id++){
		echo "<th><a href=\"./show_ap.php?l_id={$l_id}&sub_id={$sub_id}\" target=\"_blank\">課題{$sub_id}</a></th>";
	}
	echo "<th><a href=\"./read_p9.php?l_id={$l_id}\" target=\"_blank\">感想</a></th></tr>\n";
?>
<tr><td class="c"><input name="cb_all" type="checkbox" onClick="chk_all(this);"></td><td>すべて</td></tr>
			</thead>
			<tbody>
<?php
	while($data = $result_EVALS->fetch(PDO::FETCH_ASSOC)){
		$id = $data['u_id'];
		echo "<tr>\n<td class=\"c\"><input name=\"cb[{$id}]\" type=\"checkbox\" value=\"{$id}\" onClick=\"tgl_dis('{$id}');\" class=\"cb\"></td><td>{$id}</td><td>{$data['u_name']}</td>\n";
		for($sub_id = 0; $sub_id <= 9; $sub_id++){
			if(!isset($data[$slid.$sub_id])) continue;
			echo "<td class=\"c\"><select name=\"p{$sub_id}[{$id}]\" size=\"1\" disabled=\"disabled\">\n".$list_eva_opt[$data[$slid.$sub_id]]."</select></td>\n";
		}
		echo "</tr>\n";
	}
?>
<tr><td></td>
<td colspan="2"><input type="submit" name="submit" value="上記の内容で更新"></td>
			</tbody>
		</table>
	</form>
	<br>
	<table border="1">
		<tr><td>記号</td><td class="c">×</td><td class="c">▲</td><td class="c">●</td><td class="c">○</td><td class="c">◎</td></tr>
		<tr><td>評価</td><td class="c">未提出<br>無断欠席</td><td class="c">不合格<br>連絡欠席</td><td class="c">合格(遅刻)<br>遅刻</td><td class="c">合格<br>出席</td><td class="c">合格(加点)</td></tr>
	</table>
	<br>
	<a href="./show_ls.php">戻る</a><br>
	<br><br>
	<script src="/js/jquery-3.min.js"></script>
	<script src="/js/mouri_common.js"></script>
	<script>
<!--
	window.onpageshow = clear_cb;
// -->
	</script>
</body>
</html>
