<?php
	// 各定数の設定
	$SV_NAME  = "pgr";
	$YEAR4    = "2025";
	$DB_NAME  = $SV_NAME.$YEAR4;
	$DB_USER  = "DB操作ユーザ名";
	$DB_PW    = "DBパスワード";
	$SS_NAME  = $DB_NAME;
	$PATH_ACC = "/任意のディレクトリ/ws_web/acc_ctrl/";
	$USE_LDAP = TRUE;
	$PFX_KEYN = "pgnpgr_";
	$PATH_SWD = "/任意のディレクトリ/ws_web/{$SV_NAME}/{$YEAR4}/";
	$PATH_WEB = __DIR__."/";
	$SV_TITLE = $YEAR4."年度 プログラミング論 課題システム";
	$PFX_MSBJ = "（プ論）";
	$ADM_NAME = "授業担当者名";
	$ADM_MAIL = "授業担当者メールアドレス";
	$UID_TEST = "テスト用ユーザ";
	$HASH_DPW = "テスト用ユーザのパスワードハッシュ(SHA256)";
	
	$LIST_CLS = ["未定", "A", "B", "C"];
	$LIST_GRD = ["その他", "一般学生", "ＳＡ", "教職員", "管理者"];
	$GRD_ADM  = 4;
	$GRD_ADD  = 1;
	
	$LIST_DLT = ["00:00", "14:45", "16:30", "00:00"];
	$CIDR_DEF = "192.168.0.0/16";
	$TIME_END = "2026-01-26 21:01";
	$TIME_D_V = " - 7 days";
	$TIME_D_L = " + 12 days";
	
	$RATE_EV  = 0.6;
	$LIST_EVS = ["×", "▲", "確(遅)", "●", "確認中", "○", "確認中", "◎", "◇", "◇"];
	$LIST_EVA = ["×", "▲", "確(遅)", "●", "確1",    "○", "確2",    "◎", "少", "多"];
	$LIST_ATT = ["11", "12", "13", "14", "15"];
	
	// セッション再開（または開始）
	$time_now = time();
	session_name($SS_NAME);
	session_save_path("{$PATH_SWD}_sess/");
	session_start();
	header("Content-Type: text/html; charset=UTF-8");
	
	// ログイン前のアクセス制限
	$sc_name = basename($_SERVER['SCRIPT_NAME']);
	if(empty($_SESSION['u_id'])){
		$_SESSION['u_id']   = "";
		$_SESSION['cls_id'] = 0;
		$_SESSION['grd_id'] = 0;
		switch($sc_name){
			case "":
			case "index.php":
			case "login.php":
			case "logout.php":
				break;
			default:
				header("Location:./");
				exit();
				break;
		}
	}
	elseif(($sc_name != "logout.php") && (($time_now - $_SESSION['time_lst']) > 7200)){
		$t_out = TRUE;
		require_once("./logout.php");
		exit();
	}
	
	// 未登録ユーザのアクセス制限
	$_SESSION['time_lst'] = $time_now;
	$u_id   = $_SESSION['u_id'];
	$cls_id = $_SESSION['cls_id'];
	if(empty($_SESSION['u_exst']) && !empty($u_id)){
		switch($sc_name){
			case "add_u.php":
			case "login.php":
			case "logout.php":
			case "update_u.php":
				break;
			default:
				header("Location:./add_u.php");
				exit();
				break;
		}
	}
	elseif(empty($_SESSION['u_pass']) && !empty($u_id)){
		switch($sc_name){
			case "change_pw.php":
			case "logout.php":
				break;
			default:
				header("Location:./change_pw.php");
				exit();
				break;
		}
	}
	
	// 等級によるアクセス制限
	if($_SESSION['grd_id'] < $GRD_ADM){
		switch($sc_name){
			case "admin.php":
			case "edit_el.php":
			case "edit_l.php":
			case "edit_p.php":
			case "edit_ps.php":
			case "edit_us.php":
			case "read_p9.php":
			case "show_ap.php":
			case "show_es.php":
			case "show_ls.php":
			case "show_swd.php":
				exit("閲覧権限がありません．<br>");
				break;
			case "archive_swd.php":
			case "dl_tbl.php":
			case "remove.php":
			case "submit_ps.php":
			case "update_es.php":
			case "update_l.php":
			case "update_ps.php":
			case "update_us.php":
				exit("実行権限がありません．<br>");
				break;
		}
	}
?>
