<!doctype html>
<?php
	require_once("./config.php");
	require_once("{$PATH_ACC}functions.php");
	
	if(isset($_POST['passwd'])){
		// パスワードを復号してハッシュ化
		list($passwd_old, $passwd_new) = decrypt_passwd($_POST['passwd'], $PFX_KEYN);
		$passwd_old = hash("sha256", $passwd_old);
		$passwd_new = hash("sha256", $passwd_new);
		
		// DBへ接続
		try{
			$dbh = new PDO("mysql:host=localhost;dbname={$DB_NAME};charset=utf8mb4", $DB_USER, $DB_PW);
			$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		}
		catch(PDOException $e){
			exit("DBへの接続に失敗しました．<br>");
		}
		
		// パスワード認証
		$sqlstr = "SELECT passwd FROM users WHERE u_id='{$u_id}';";
		try{
			$result = $dbh->query($sqlstr);
		}
		catch(PDOException $e){
			exit("ユーザ情報の取得に失敗しました．<br>");
		}
		$data = $result->fetch(PDO::FETCH_ASSOC);
		
		// passwd（空欄ならデフォルト）と突合せ
		if(empty($data['passwd'])){
			if($passwd_old != $HASH_DPW){
				exit("デフォルトパスワードが異なります．<br>");
			}
		}
		elseif($passwd_old != $data['passwd']){
			exit("旧パスワードが異なります．<br>");
		}
		
		// パスワードの更新
		if($passwd_new == $HASH_DPW){
			exit("新パスワードはデフォルト以外にして下さい．<br>");
		}
		$sqlstr = "UPDATE users SET passwd='{$passwd_new}' WHERE u_id='{$u_id}';";
		if($dbh->exec($sqlstr) === FALSE){
			exit("パスワードの更新に失敗しました．<br>");
		}
		$_SESSION['u_pass'] = TRUE;
		exit("パスワードを更新しました．<br><br><a href=\"./\">トップページ</a>");
	}
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta name="viewport" content="width=device-width,initial-scale=1.0">
	<title><?= $SV_TITLE; ?> パスワードの更新ページ</title>
	<link rel="stylesheet" type="text/css" href="base.css">
	<link rel="stylesheet" type="text/css" href="form.css">
<?php
	include_once("{$PATH_ACC}crypt_pw.txt");
?>
</head>
<body>
	<h1><?= $SV_TITLE; ?></h1>
	<h2>パスワードの更新ページ</h2>
<?php
	if($_SESSION['u_pass'] === FALSE){
		echo "<span style=\"color:red;\"><b>パスワードをデフォルト以外に変更して下さい．</b></span><br>";
	}
?>
	<form id="form1" action="./change_pw.php" method="post" enctype="multipart/form-data" onSubmit="return chk_pw()">
		<table>
<tr><td>学籍番号：</td><td><?= $u_id; ?></td></tr>
<tr><td><?= ($_SESSION['u_pass'] === FALSE) ? "デフォルト<br>パスワード" : "旧パスワード"; ?>：</td><td>
	<input name="passwd[]" type="password" class="password">
</td></tr>
<tr><td>新パスワード：</td><td>
	<input name="passwd[]" type="password" class="password">
</td></tr>
<tr><td>確認用：</td><td>
	<input name="passwd_chk" type="password" class="password">
</td></tr>
<tr><td></td><td>
	<input name="submit" type="submit" value="上記の内容で更新">
</td></tr>
		</table>
	</form>
	<br>
	<a href="./logout.php">ログアウト</a><br>
	<br><br>
</body>
</html>
